/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.pmap;

import ca.odell.glazedlists.impl.pmap.Chunk;
import ca.odell.glazedlists.impl.pmap.ValueCallback;
import java.io.IOException;
import java.util.logging.Logger;

class LoadValue
implements Runnable {
    private static Logger logger = Logger.getLogger(LoadValue.class.toString());
    private final Chunk chunk;
    private final ValueCallback valueCallback;

    public LoadValue(Chunk chunk, ValueCallback valueCallback) {
        this.chunk = chunk;
        this.valueCallback = valueCallback;
    }

    @Override
    public void run() {
        try {
            if (!this.chunk.isOn()) {
                throw new IOException("Chunk has been destroyed");
            }
            this.valueCallback.valueLoaded(this.chunk, this.chunk.readValue());
        }
        catch (IOException e) {
            this.chunk.getPersistentMap().fail(e, "Failed to read value from file " + this.chunk.getPersistentMap().getFile().getPath());
            this.valueCallback.valueLoaded(this.chunk, null);
        }
    }
}

