/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.DataTypeNamingUtil;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.pdb.pdbapplicator.ArgumentsListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;

public abstract class AbstractFunctionTypeApplier
extends MsTypeApplier {
    private FunctionDefinitionDataType functionDefinition;
    private MsTypeApplier returnApplier;
    private ArgumentsListTypeApplier argsListApplier;
    private CallingConvention callingConvention;
    private boolean hasThisPointer;

    public AbstractFunctionTypeApplier(DefaultPdbApplicator applicator, AbstractMsType msType) {
        super(applicator, msType);
        this.functionDefinition = new FunctionDefinitionDataType(applicator.getAnonymousFunctionsCategory(), "_func", applicator.getDataTypeManager());
        this.dataType = this.functionDefinition;
    }

    @Override
    void deferredApply() throws PdbException, CancelledException {
        if (this.isDeferred()) {
            this.applyInternal();
        }
    }

    FunctionDefinitionDataType getFunctionDefinition() {
        return this.functionDefinition;
    }

    @Override
    DataType getCycleBreakType() {
        if (this.dataType != null) {
            return this.dataType;
        }
        return this.functionDefinition;
    }

    MsTypeApplier getReturnTypeApplier() {
        return this.applicator.getTypeApplier(this.getReturnRecordNumber());
    }

    ArgumentsListTypeApplier getArgsListApplier() {
        MsTypeApplier argsApplier = this.applicator.getTypeApplier(this.getArgListRecordNumber());
        if (argsApplier instanceof ArgumentsListTypeApplier) {
            return (ArgumentsListTypeApplier)this.applicator.getTypeApplier(this.getArgListRecordNumber());
        }
        return null;
    }

    protected abstract CallingConvention getCallingConvention();

    protected abstract boolean hasThisPointer();

    protected abstract RecordNumber getReturnRecordNumber();

    protected abstract RecordNumber getArgListRecordNumber();

    protected boolean isConstructor() {
        return false;
    }

    protected DataType applyFunction(CallingConvention callingConventionParam, boolean hasThisPointerParam) throws PdbException, CancelledException {
        this.callingConvention = callingConventionParam;
        this.hasThisPointer = hasThisPointerParam;
        this.returnApplier = this.getReturnTypeApplier();
        this.argsListApplier = this.getArgsListApplier();
        this.applyOrDeferForDependencies();
        return this.functionDefinition;
    }

    private void applyOrDeferForDependencies() throws CancelledException {
        if (this.returnApplier.isDeferred()) {
            this.applicator.addApplierDependency(this, this.returnApplier);
            this.setDeferred();
        }
        if (this.argsListApplier != null) {
            this.argsListApplier.checkForDependencies(this);
        }
        if (!this.isDeferred()) {
            this.applyInternal();
        }
    }

    private void applyInternal() throws CancelledException {
        if (this.isApplied()) {
            return;
        }
        if (!this.setReturnType()) {
            return;
        }
        if (this.argsListApplier != null) {
            this.argsListApplier.applyTo(this);
        }
        this.setCallingConvention(this.applicator, this.callingConvention, this.hasThisPointer);
        DataTypeNamingUtil.setMangledAnonymousFunctionName((FunctionDefinitionDataType)this.functionDefinition);
        this.setApplied();
    }

    private boolean setReturnType() {
        if (this.isConstructor()) {
            return true;
        }
        DataType returnDataType = this.returnApplier.getDataType();
        if (returnDataType == null) {
            this.applicator.appendLogMsg("Return type is null in " + this.functionDefinition.getName());
            return false;
        }
        this.functionDefinition.setReturnType(returnDataType);
        return true;
    }

    private void setCallingConvention(DefaultPdbApplicator applicator, CallingConvention callingConvention, boolean hasThisPointer) {
        String convention;
        if (hasThisPointer) {
            convention = "__thiscall";
        } else {
            switch (callingConvention) {
                case THISCALL: {
                    convention = "__thiscall";
                    break;
                }
                case NEAR_C: {
                    convention = "__cdecl";
                    break;
                }
                case NEAR_VECTOR: {
                    convention = "__vectorcall";
                    break;
                }
                default: {
                    convention = "__cdecl";
                }
            }
        }
        try {
            this.functionDefinition.setCallingConvention(convention);
        }
        catch (InvalidInputException e) {
            applicator.appendLogMsg("Failed to set calling convention `" + convention + "` for " + this.functionDefinition.getName());
        }
    }
}

