/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DbgReadRegistersCommand
extends AbstractDbgCommand<Map<DbgRegister, BigInteger>> {
    private final DbgThreadImpl thread;
    private final Set<DbgRegister> regs;
    private DebugRegisters registers;
    private Map<DbgRegister, BigInteger> result = new LinkedHashMap<DbgRegister, BigInteger>();

    public DbgReadRegistersCommand(DbgManagerImpl manager, DbgThreadImpl thread, Integer frameId, Set<DbgRegister> regs) {
        super(manager);
        this.thread = thread;
        this.regs = regs;
    }

    @Override
    public Map<DbgRegister, BigInteger> complete(DbgPendingCommand<?> pending) {
        if (this.regs.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() {
        try {
            this.setThread(this.thread);
            this.registers = this.manager.getClient().getRegisters();
            if (this.registers != null) {
                for (DbgRegister r : this.regs) {
                    DebugValue value;
                    if (!r.isBaseRegister() || (value = this.registers.getValueByName(r.getName())) == null) continue;
                    BigInteger bval = new BigInteger(value.encodeAsBytes());
                    this.result.put(r, bval);
                }
            }
        }
        finally {
            this.resetThread();
        }
    }
}

