/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ISF.IsfBuiltIn;
import ghidra.program.model.data.ISF.IsfComposite;
import ghidra.program.model.data.ISF.IsfDataTypeArray;
import ghidra.program.model.data.ISF.IsfDataTypeBitField;
import ghidra.program.model.data.ISF.IsfDataTypeDefault;
import ghidra.program.model.data.ISF.IsfDataTypeNull;
import ghidra.program.model.data.ISF.IsfDataTypeTypeDef;
import ghidra.program.model.data.ISF.IsfDynamicComponent;
import ghidra.program.model.data.ISF.IsfEnum;
import ghidra.program.model.data.ISF.IsfFunctionPointer;
import ghidra.program.model.data.ISF.IsfLinuxOS;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfProducer;
import ghidra.program.model.data.ISF.IsfTypedObject;
import ghidra.program.model.data.ISF.IsfTypedefBase;
import ghidra.program.model.data.ISF.IsfTypedefIntegral;
import ghidra.program.model.data.ISF.IsfTypedefPointer;
import ghidra.program.model.data.ISF.IsfUtilities;
import ghidra.program.model.data.ISF.IsfWinOS;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IsfDataTypeWriter {
    private Map<DataType, IsfObject> resolved = new HashMap<DataType, IsfObject>();
    private Map<String, DataType> resolvedTypeMap = new HashMap<String, DataType>();
    private List<String> deferredKeys = new ArrayList<String>();
    private Writer baseWriter;
    private JsonWriter writer;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private DataTypeManager dtm;
    private DataOrganization dataOrganization;
    private JsonObject data = new JsonObject();
    private JsonObject metadata = new JsonObject();
    private JsonObject baseTypes = new JsonObject();
    private JsonObject userTypes = new JsonObject();
    private JsonObject enums = new JsonObject();
    private JsonObject symbols = new JsonObject();
    private List<Address> requestedAddresses = new ArrayList<Address>();
    private List<String> requestedSymbols = new ArrayList<String>();
    private List<String> requestedTypes = new ArrayList<String>();
    private List<DataType> requestedDataTypes = new ArrayList<DataType>();
    private boolean skipSymbols = false;
    private boolean skipTypes = false;
    private boolean STRICT = true;
    ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return IsfDataTypeWriter.this.STRICT && field.getAnnotation(Exclude.class) != null;
        }
    };

    public IsfDataTypeWriter(DataTypeManager dtm, Writer baseWriter) throws IOException {
        this.dtm = dtm;
        if (dtm != null) {
            this.dataOrganization = dtm.getDataOrganization();
        }
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        this.baseWriter = baseWriter;
        this.writer = new JsonWriter(baseWriter);
        this.writer.setIndent("  ");
        this.gson = new GsonBuilder().addSerializationExclusionStrategy(this.strategy).setPrettyPrinting().create();
    }

    public JsonObject getRootObject(TaskMonitor monitor) throws IOException, CancelledException {
        this.genMetadata();
        this.genTypes(monitor);
        this.genSymbols();
        this.genRoot();
        return this.data;
    }

    private void genRoot() {
        this.data.add("metadata", (JsonElement)this.metadata);
        this.data.add("base_types", (JsonElement)this.baseTypes);
        this.data.add("user_types", (JsonElement)this.userTypes);
        this.data.add("enums", (JsonElement)this.enums);
        this.data.add("symbols", (JsonElement)this.symbols);
    }

    private void genMetadata() {
        String oskey = "UNKNOWN";
        if (this.dtm instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)this.dtm;
            Program program = pgmDtm.getProgram();
            Map metaData = program.getMetadata();
            JsonElement producer = this.gson.toJsonTree((Object)new IsfProducer(program));
            JsonObject os = new JsonObject();
            oskey = (String)metaData.get("Compiler ID");
            if (metaData.containsKey("PDB Loaded")) {
                os = this.gson.toJsonTree((Object)new IsfWinOS(metaData));
            } else if (metaData.containsKey("Executable Format") && ((String)metaData.get("Executable Format")).contains("ELF")) {
                oskey = "linux";
                os = this.gson.toJsonTree((Object)new IsfLinuxOS(this.gson, metaData));
            }
            this.metadata.addProperty("format", "6.2.0");
            this.metadata.add("producer", producer);
            this.metadata.add(oskey, (JsonElement)os);
        }
    }

    private void genSymbols() {
        if (!this.skipSymbols && this.dtm instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)this.dtm;
            Program program = pgmDtm.getProgram();
            Address imageBase = program.getImageBase();
            SymbolTable symbolTable = program.getSymbolTable();
            ReferenceManager referenceManager = program.getReferenceManager();
            ReferenceIterator xrefs = referenceManager.getExternalReferences();
            HashMap<String, Symbol> linkages = new HashMap<String, Symbol>();
            for (Reference reference : xrefs) {
                Address address = reference.getFromAddress();
                Address toAddress = reference.getToAddress();
                Symbol[] fromSymbol = symbolTable.getPrimarySymbol(address);
                Symbol toSymbol = symbolTable.getPrimarySymbol(toAddress);
                if (fromSymbol == null) continue;
                linkages.put(toSymbol.getName(), (Symbol)fromSymbol);
            }
            HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
            if (this.requestedSymbols.isEmpty()) {
                if (this.requestedAddresses.isEmpty()) {
                    SymbolIterator iterator = symbolTable.getSymbolIterator();
                    while (iterator.hasNext()) {
                        Symbol symbol = iterator.next();
                        this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                    }
                } else {
                    for (Address address : this.requestedAddresses) {
                        Symbol[] symsFromAddr;
                        for (Symbol symbol : symsFromAddr = symbolTable.getSymbols(address.add(imageBase.getOffset()))) {
                            this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                        }
                    }
                }
            } else {
                for (String string : this.requestedSymbols) {
                    SymbolIterator iter = symbolTable.getSymbols(string);
                    while (iter.hasNext()) {
                        Symbol symbol = iter.next();
                        this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                    }
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                this.symbols.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            for (Map.Entry entry : map.entrySet()) {
                String nu;
                if (!((String)entry.getKey()).startsWith("_") || this.symbols.get(nu = ((String)entry.getKey()).substring(1)) != null) continue;
                this.symbols.add(nu, (JsonElement)entry.getValue());
            }
        }
    }

    private void genTypes(TaskMonitor monitor) throws CancelledException, IOException {
        if (this.skipTypes) {
            return;
        }
        HashMap<String, DataType> map = new HashMap<String, DataType>();
        if (this.requestedDataTypes.isEmpty()) {
            this.dtm.getAllDataTypes(this.requestedDataTypes);
            this.baseTypes.add("pointer", this.getTree(new IsfTypedefPointer()));
            this.baseTypes.add("undefined", this.getTree(new IsfTypedefPointer()));
        }
        monitor.initialize((long)this.requestedDataTypes.size());
        for (DataType dataType : this.requestedDataTypes) {
            String key = dataType.getName();
            map.put(key, dataType);
        }
        ArrayList<String> keylist = new ArrayList<String>(map.keySet());
        Collections.sort(keylist);
        this.processMap(map, keylist, monitor);
        if (!this.deferredKeys.isEmpty()) {
            Msg.warn((Object)this, (Object)"Processing .conflict objects");
            ArrayList<String> defkeys = new ArrayList<String>();
            defkeys.addAll(this.deferredKeys);
            this.processMap(map, defkeys, monitor);
        }
    }

    private void processMap(Map<String, DataType> map, List<String> keylist, TaskMonitor monitor) throws CancelledException, IOException {
        JsonObject obj = new JsonObject();
        int cnt = 0;
        for (String key : keylist) {
            DataType dataType = map.get(key);
            monitor.checkCancelled();
            if (key.contains(".conflict") || (obj = this.getObjectForDataType(dataType, monitor)) == null) continue;
            if (!(dataType instanceof FunctionDefinition)) {
                if (IsfUtilities.isBaseDataType(dataType)) {
                    this.baseTypes.add(dataType.getName(), (JsonElement)obj);
                } else if (dataType instanceof TypeDef) {
                    DataType baseDataType = ((TypeDef)dataType).getBaseDataType();
                    if (IsfUtilities.isBaseDataType(baseDataType)) {
                        this.baseTypes.add(dataType.getName(), (JsonElement)obj);
                    } else if (baseDataType instanceof Enum) {
                        this.enums.add(dataType.getName(), (JsonElement)obj);
                    } else {
                        this.userTypes.add(dataType.getName(), (JsonElement)obj);
                    }
                } else if (dataType instanceof Enum) {
                    this.enums.add(dataType.getName(), (JsonElement)obj);
                } else if (dataType instanceof Composite) {
                    this.userTypes.add(dataType.getName(), (JsonElement)obj);
                }
            }
            monitor.setProgress((long)(++cnt));
        }
    }

    private void symbolToJson(Address imageBase, SymbolTable symbolTable, Map<String, Symbol> linkages, Map<String, JsonObject> map, Symbol symbol) {
        JsonObject sym;
        String key = symbol.getName();
        Address address = symbol.getAddress();
        JsonObject jsonObject = sym = map.containsKey(key) ? map.get(key) : new JsonObject();
        if (address.isExternalAddress()) {
            sym.addProperty("address", (Number)address.getOffset());
            if (linkages.containsKey(key)) {
                Symbol linkage = linkages.get(key);
                sym.addProperty("linkage_name", linkage.getName());
                sym.addProperty("address", (Number)linkage.getAddress().getOffset());
            }
        } else {
            sym.addProperty("address", (Number)address.subtract(imageBase));
        }
        map.put(symbol.getName(), sym);
        if (!symbol.isPrimary()) {
            Symbol primarySymbol = symbolTable.getPrimarySymbol(address);
            String primaryName = primarySymbol.getName();
            if (symbol.getName().contains(primaryName)) {
                sym.addProperty("linkage_name", symbol.getName());
                map.put(primaryName, sym);
            }
        }
    }

    public void write(JsonObject obj) {
        this.gson.toJson((JsonElement)obj, this.writer);
    }

    JsonObject getObjectForDataType(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        IsfObject isf = this.getIsfObject(dt, monitor);
        if (isf != null) {
            JsonObject jobj = (JsonObject)this.getTree(isf);
            this.resolved.put(dt, isf);
            return jobj;
        }
        return null;
    }

    private IsfObject getIsfObject(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        if (dt == null) {
            Msg.error((Object)this, (Object)"Shouldn't get here - null datatype passed");
            return null;
        }
        if (dt instanceof FactoryDataType) {
            Msg.error((Object)this, (Object)("Factory data types may not be written - type: " + dt));
        }
        if (dt instanceof Pointer || dt instanceof Array || dt instanceof BitFieldDataType) {
            IsfObject type = this.getObjectDataType(IsfUtilities.getBaseDataType(dt));
            IsfTypedObject obj = new IsfTypedObject(dt, type);
            return obj;
        }
        IsfObject res = this.resolve(dt = dt.clone(this.dtm));
        if (res != null) {
            return res;
        }
        if (dt instanceof Dynamic) {
            Dynamic dynamic = (Dynamic)dt;
            DataType rep = dynamic.getReplacementBaseType();
            return rep == null ? null : this.getIsfObject(rep, monitor);
        }
        if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            return this.getObjectTypeDef(typedef, monitor);
        }
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return new IsfComposite(composite, this, monitor);
        }
        if (dt instanceof Enum) {
            Enum enumm = (Enum)dt;
            return new IsfEnum(enumm);
        }
        if (dt instanceof BuiltInDataType) {
            BuiltInDataType builtin = (BuiltInDataType)dt;
            return new IsfBuiltIn(builtin);
        }
        if (!(dt instanceof BitFieldDataType || dt instanceof FunctionDefinition || dt.equals(DataType.DEFAULT))) {
            Msg.warn((Object)this, (Object)("Unable to write datatype. Type unrecognized: " + dt.getClass()));
        }
        return null;
    }

    private IsfObject resolve(DataType dt) {
        if (this.resolved.containsKey(dt)) {
            return this.resolved.get(dt);
        }
        DataType resolvedType = this.resolvedTypeMap.get(dt.getName());
        if (resolvedType != null) {
            if (resolvedType.isEquivalent(dt)) {
                return this.resolved.get(dt);
            }
            if (dt instanceof TypeDef) {
                DataType baseType = ((TypeDef)dt).getBaseDataType();
                if ((resolvedType instanceof Composite || resolvedType instanceof Enum) && baseType.isEquivalent(resolvedType)) {
                    return this.resolved.get(dt);
                }
            }
            Msg.warn((Object)this, (Object)("WARNING! conflicting data type names: " + dt.getPathName() + " - " + resolvedType.getPathName()));
            return this.resolved.get(dt);
        }
        this.resolvedTypeMap.put(dt.getName(), dt);
        return null;
    }

    private void clearResolve(String typedefName, DataType baseType) {
        if (baseType instanceof Composite || baseType instanceof Enum) {
            if (typedefName.equals(baseType.getName())) {
                this.resolvedTypeMap.remove(typedefName);
                return;
            }
        } else if (baseType instanceof Pointer && typedefName.startsWith("P")) {
            DataType dt = ((Pointer)baseType).getDataType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (dt instanceof Composite && dt.getName().equals(typedefName.substring(1))) {
                this.resolvedTypeMap.remove(typedefName);
                return;
            }
        }
    }

    public IsfObject getObjectTypeDeclaration(DataTypeComponent component) {
        DataType dataType = component.getDataType();
        if (dataType instanceof Dynamic) {
            DataType replacementBaseType;
            Dynamic dynamic = (Dynamic)dataType;
            if (dynamic.canSpecifyLength() && (replacementBaseType = dynamic.getReplacementBaseType()) != null) {
                replacementBaseType = replacementBaseType.clone(this.dtm);
                IsfObject type = this.getObjectDataType(replacementBaseType);
                int elementLen = replacementBaseType.getLength();
                if (elementLen > 0) {
                    int elementCnt = (component.getLength() + elementLen - 1) / elementLen;
                    return new IsfDynamicComponent(dynamic, type, elementCnt);
                }
                Msg.error((Object)this, (Object)(dynamic.getClass().getSimpleName() + " returned bad replacementBaseType: " + replacementBaseType.getClass().getSimpleName()));
            }
            return null;
        }
        DataType baseDataType = IsfUtilities.getBaseDataType(dataType);
        if (baseDataType instanceof FunctionDefinition) {
            FunctionDefinition def = (FunctionDefinition)baseDataType;
            return new IsfFunctionPointer(def, baseDataType);
        }
        return this.getObjectDataType(dataType, component.getOffset());
    }

    public IsfObject getObjectDataType(DataType dataType) {
        return this.getObjectDataType(dataType, -1);
    }

    private IsfObject getObjectDataType(DataType dataType, int componentOffset) {
        if (dataType == null) {
            return new IsfDataTypeNull();
        }
        DataType baseType = IsfUtilities.getBaseDataType(dataType);
        if (!dataType.equals(baseType)) {
            if (dataType instanceof Array) {
                Array arr = (Array)dataType;
                IsfObject type = this.getObjectDataType(arr.getDataType());
                return new IsfDataTypeArray(arr, type);
            }
            if (dataType instanceof BitFieldDataType) {
                BitFieldDataType bf = (BitFieldDataType)dataType;
                IsfObject type = this.getObjectDataType(bf.getBaseDataType());
                return new IsfDataTypeBitField(bf, componentOffset, type);
            }
            IsfObject baseObject = this.getObjectDataType(IsfUtilities.getBaseDataType(dataType));
            return new IsfDataTypeTypeDef(dataType, baseObject);
        }
        if (dataType.getName().contains(".conflict") && !this.deferredKeys.contains(dataType.getName())) {
            this.deferredKeys.add(dataType.getName());
        }
        return new IsfDataTypeDefault(dataType);
    }

    private IsfObject getObjectTypeDef(TypeDef typeDef, TaskMonitor monitor) throws CancelledException {
        String dataTypeName;
        DataType dataType = typeDef.getDataType();
        String typedefName = typeDef.getDisplayName();
        if (IsfUtilities.isIntegral(typedefName, dataTypeName = dataType.getDisplayName())) {
            return new IsfTypedefIntegral(typeDef);
        }
        DataType baseType = typeDef.getBaseDataType();
        try {
            if (baseType instanceof BuiltInDataType) {
                BuiltInDataType builtin = (BuiltInDataType)baseType;
                return new IsfTypedefBase(typeDef);
            }
            if (!(baseType instanceof Pointer)) {
                return this.getIsfObject(dataType, monitor);
            }
            return new IsfTypedefPointer();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("TypeDef error: " + e));
            this.clearResolve(typedefName, baseType);
            return null;
        }
    }

    public JsonElement getTree(Object obj) {
        return this.gson.toJsonTree(obj);
    }

    public void requestAddress(String key) {
        DataTypeManager dataTypeManager = this.dtm;
        if (dataTypeManager instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)dataTypeManager;
            try {
                Address address = pgmDtm.getProgram().getMinAddress().getAddress(key);
                if (address == null) {
                    Msg.error((Object)this, (Object)(address + " not found"));
                    return;
                }
                this.requestedAddresses.add(address);
            }
            catch (AddressFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void requestSymbol(String symbol) {
        if (symbol == null) {
            Msg.error((Object)this, (Object)(symbol + " not found"));
            return;
        }
        this.requestedSymbols.add(symbol);
    }

    public void requestType(String path) {
        this.requestedTypes.add(path);
        DataType dataType = this.dtm.getDataType(path);
        if (dataType == null) {
            Msg.error((Object)this, (Object)(path + " not found"));
            return;
        }
        this.requestedDataTypes.add(dataType);
    }

    public void requestType(DataType dataType) {
        if (dataType == null) {
            Msg.error((Object)this, (Object)(dataType + " not found"));
            return;
        }
        this.requestedDataTypes.add(dataType);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.baseWriter.toString();
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSkipSymbols(boolean val) {
        this.skipSymbols = val;
    }

    public void setSkipTypes(boolean val) {
        this.skipTypes = val;
    }

    public void setStrict(boolean val) {
        this.STRICT = val;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }
}

