/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractBinaryExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.DefaultSolverHint;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.LeftShiftExpression;
import ghidra.util.Msg;
import java.util.Map;
import java.util.Set;

public class LeftShiftExpressionSolver
extends AbstractBinaryExpressionSolver<LeftShiftExpression> {
    public LeftShiftExpressionSolver() {
        super(LeftShiftExpression.class);
    }

    @Override
    public MaskedLong compute(MaskedLong lval, MaskedLong rval) {
        return lval.shiftLeft(rval);
    }

    @Override
    public MaskedLong computeLeft(MaskedLong rval, MaskedLong goal) throws SolverException {
        return goal.invShiftLeft(rval);
    }

    @Override
    public MaskedLong computeRight(MaskedLong lval, MaskedLong goal) throws SolverException {
        long acc = 0L;
        long bit = 1L;
        for (int i = 0; i < 64; ++i) {
            if (lval.shiftLeft(i).agrees(goal)) {
                acc |= bit;
            }
            bit <<= 1;
        }
        if (Long.bitCount(acc) == 1) {
            return MaskedLong.fromLong(Long.numberOfTrailingZeros(acc));
        }
        throw new SolverException("Cannot solve for the left shift amount: " + goal + " = " + lval + " << L");
    }

    @Override
    protected AssemblyResolution solveTwoSided(LeftShiftExpression exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        if (hints.contains(DefaultSolverHint.GUESSING_LEFT_SHIFT_AMOUNT)) {
            return super.solveTwoSided(exp, goal, vals, cur, hints, description);
        }
        int maxShift = Long.numberOfTrailingZeros(goal.val);
        Set<SolverHint> hintsWithLShift = SolverHint.with(hints, DefaultSolverHint.GUESSING_LEFT_SHIFT_AMOUNT);
        if (maxShift == 64) {
            try {
                AssemblyResolution lres = this.solver.solve(exp.getLeft(), goal, vals, cur, hintsWithLShift, description);
                if (lres.isError()) {
                    throw new SolverException("Solving left:=0 failed");
                }
                return lres;
            }
            catch (SolverException | UnsupportedOperationException e) {
                Msg.trace((Object)this, (Object)("Trying left:=0 in shift resulted in " + e));
            }
        }
        for (int shift = maxShift; shift >= 0; --shift) {
            try {
                MaskedLong reqr = MaskedLong.fromLong(shift);
                MaskedLong reql = this.computeLeft(reqr, goal);
                AssemblyResolution lres = this.solver.solve(exp.getLeft(), reql, vals, cur, hintsWithLShift, description);
                if (lres.isError()) {
                    throw new SolverException("Solving left failed");
                }
                AssemblyResolution rres = this.solver.solve(exp.getRight(), reqr, vals, cur, hints, description);
                if (rres.isError()) {
                    throw new SolverException("Solving right failed");
                }
                AssemblyResolvedPatterns lsol = (AssemblyResolvedPatterns)lres;
                AssemblyResolvedPatterns rsol = (AssemblyResolvedPatterns)rres;
                AssemblyResolvedPatterns sol = lsol.combine(rsol);
                if (sol == null) {
                    throw new SolverException("Left and right solutions conflict for shift=" + shift);
                }
                return sol;
            }
            catch (SolverException | UnsupportedOperationException e) {
                Msg.trace((Object)this, (Object)("Shift of " + shift + " resulted in " + e));
                continue;
            }
        }
        return super.solveTwoSided(exp, goal, vals, cur, hints, description);
    }
}

