/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import docking.widgets.OkDialog;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PartialUnion;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;

public class ForceUnionAction
extends AbstractDecompilerAction {
    private Varnode accessVn;
    private PcodeOp accessOp;
    private int accessSlot;
    private int fieldNumber;
    private Union unionDt;
    private DataType parentDt;
    private Address pcAddr;

    public ForceUnionAction() {
        super("Force Union Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionForceField"));
        this.setPopupMenuData(new MenuData(new String[]{"Force Field"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (!(tokenAtCursor instanceof ClangFieldToken)) {
            return false;
        }
        Composite composite = ForceUnionAction.getCompositeDataType(tokenAtCursor);
        return composite instanceof Union;
    }

    private DataType typeIsUnionRelated(Varnode vn) {
        DataType innerType;
        if (vn == null) {
            return null;
        }
        HighVariable high = vn.getHigh();
        if (high == null) {
            return null;
        }
        DataType dt = high.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if ((innerType = dt) instanceof Pointer) {
            innerType = ((Pointer)innerType).getDataType();
        } else if (innerType instanceof PartialUnion && (innerType = ((PartialUnion)innerType).getParent()) instanceof TypeDef) {
            innerType = ((TypeDef)innerType).getBaseDataType();
        }
        if (innerType == this.unionDt) {
            return dt;
        }
        HighSymbol symbol = high.getSymbol();
        if (symbol == null) {
            return null;
        }
        dt = symbol.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt == this.unionDt ? dt : null;
    }

    private void determineFacet(ClangToken tokenAtCursor) {
        this.accessOp = tokenAtCursor.getPcodeOp();
        int opcode = this.accessOp.getOpcode();
        if (opcode == 66) {
            this.parentDt = this.typeIsUnionRelated(this.accessOp.getInput(0));
            if (this.parentDt == null) {
                this.accessOp = null;
                return;
            }
            this.accessVn = this.accessOp.getInput(0);
            this.accessSlot = 0;
            if (this.accessOp.getInput(1).getOffset() == 0L) {
                Varnode tmpVn;
                PcodeOp tmpOp;
                while ((tmpOp = (tmpVn = this.accessOp.getOutput()).getLoneDescend()) != null) {
                    this.accessOp = tmpOp;
                    this.accessVn = tmpVn;
                    this.accessSlot = this.accessOp.getSlot(this.accessVn);
                    if (this.accessOp.getOpcode() == 66 && this.accessOp.getInput(1).getOffset() == 0L) continue;
                    break;
                }
            }
        } else {
            this.accessSlot = 0;
            while (this.accessSlot < this.accessOp.getNumInputs()) {
                this.accessVn = this.accessOp.getInput(this.accessSlot);
                this.parentDt = this.typeIsUnionRelated(this.accessVn);
                if (this.parentDt != null) break;
                ++this.accessSlot;
            }
            if (this.accessSlot >= this.accessOp.getNumInputs()) {
                this.accessSlot = -1;
                this.accessVn = this.accessOp.getOutput();
                this.parentDt = this.typeIsUnionRelated(this.accessVn);
                if (this.parentDt == null) {
                    this.accessOp = null;
                    return;
                }
            }
            if (opcode == 63 && this.accessSlot == 0 && !(this.parentDt instanceof Pointer)) {
                this.accessSlot = -1;
                this.accessVn = this.accessOp.getOutput();
            }
        }
    }

    private String[] buildFieldOptions(ArrayList<String> allFields) {
        int size = this.accessVn.getSize();
        int startOff = 0;
        boolean exactMatch = true;
        if (this.parentDt instanceof Pointer) {
            size = 0;
        }
        if (this.parentDt instanceof PartialUnion) {
            startOff = ((PartialUnion)this.parentDt).getOffset();
            exactMatch = false;
        }
        int endOff = startOff + size;
        DataTypeComponent[] components = this.unionDt.getDefinedComponents();
        ArrayList<String> res = new ArrayList<String>();
        allFields.add("(no field)");
        if (size == 0 || !exactMatch || size == this.parentDt.getLength()) {
            res.add("(no field)");
        }
        for (DataTypeComponent component : components) {
            String nm = component.getFieldName();
            if (nm == null || nm.length() == 0) {
                nm = component.getDefaultFieldName();
            }
            allFields.add(nm);
            int compStart = component.getOffset();
            int compEnd = compStart + component.getLength();
            if (size != 0 && (!exactMatch || startOff != compStart || endOff != compEnd) && (exactMatch || startOff < compStart || endOff > compEnd)) continue;
            res.add(nm);
        }
        String[] resArray = new String[res.size()];
        res.toArray(resArray);
        return resArray;
    }

    private boolean selectFieldNumber(String defaultFieldName) {
        String userChoice;
        ArrayList<String> allFields = new ArrayList<String>();
        String[] choices = this.buildFieldOptions(allFields);
        if (choices.length < 2) {
            OkDialog.show((String)"No Field Choices", (String)"Only one field fits the selected variable");
            return false;
        }
        int currentChoice = allFields.indexOf(defaultFieldName);
        if (currentChoice < 0) {
            defaultFieldName = null;
        }
        if ((userChoice = OptionDialog.showInputChoiceDialog(null, (String)("Select Field for " + this.unionDt.getName()), (String)("Field for " + this.unionDt.getName() + ": "), (String[])choices, (String)defaultFieldName, (int)-1)) == null) {
            return false;
        }
        this.fieldNumber = allFields.indexOf(userChoice);
        if (this.fieldNumber < 0 || this.fieldNumber == currentChoice) {
            return false;
        }
        --this.fieldNumber;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighFunction highFunction = context.getHighFunction();
        this.unionDt = (Union)ForceUnionAction.getCompositeDataType(tokenAtCursor);
        this.determineFacet(tokenAtCursor);
        if (this.accessOp == null || this.accessVn == null) {
            Msg.showError((Object)((Object)this), null, (String)"Force Union failed", (Object)"Could not recover p-code op");
            return;
        }
        if (!this.selectFieldNumber(tokenAtCursor.getText())) {
            return;
        }
        Function function = highFunction.getFunction();
        DynamicHash dhash = new DynamicHash(this.accessOp, this.accessSlot, (PcodeSyntaxTree)highFunction);
        this.pcAddr = dhash.getAddress();
        if (this.pcAddr == Address.NO_ADDRESS) {
            Msg.showError((Object)((Object)this), null, (String)"Force Union failed", (Object)"Unable to find a unique hash");
        }
        int transaction = program.startTransaction("Force Union");
        try {
            HighFunctionDBUtil.writeUnionFacet((Function)function, (DataType)this.parentDt, (int)this.fieldNumber, (Address)this.pcAddr, (long)dhash.getHash(), (SourceType)SourceType.USER_DEFINED);
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)((Object)this), null, (String)"Force Union failed", (Object)e.getMessage());
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), null, (String)"Force Union failed", (Object)e.getMessage());
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }
}

