/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangMarkup;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompileProcess;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParamID;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.symbol.IllegalCharCppTransformer;
import ghidra.program.model.symbol.NameTransformer;

public class DecompileResults {
    private Function function;
    private Language language;
    private CompilerSpec compilerSpec;
    private PcodeDataTypeManager dtmanage;
    private HighFunction hfunc;
    private HighParamID hparamid;
    private ClangTokenGroup docroot;
    private String errMsg;
    private DecompileProcess.DisposeState processState;

    public DecompileResults(Function f, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager d, String e, Decoder decoder, DecompileProcess.DisposeState processState) {
        this.function = f;
        this.language = language;
        this.compilerSpec = compilerSpec;
        this.dtmanage = d;
        this.errMsg = e;
        this.hfunc = null;
        this.hparamid = null;
        this.docroot = null;
        this.decodeStream(decoder);
    }

    public boolean decompileCompleted() {
        return this.hfunc != null || this.hparamid != null;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean isTimedOut() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_TIMEOUT;
    }

    public boolean isCancelled() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_CANCEL;
    }

    public boolean failedToStart() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_STARTUP_FAILURE;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public HighFunction getHighFunction() {
        return this.hfunc;
    }

    public HighParamID getHighParamID() {
        return this.hparamid;
    }

    public ClangTokenGroup getCCodeMarkup() {
        return this.docroot;
    }

    public DecompiledFunction getDecompiledFunction() {
        if (this.docroot == null) {
            return null;
        }
        PrettyPrinter printer = new PrettyPrinter(this.function, this.docroot, (NameTransformer)new IllegalCharCppTransformer());
        return printer.print();
    }

    private void decodeStream(Decoder decoder) {
        if (decoder == null || decoder.isEmpty()) {
            return;
        }
        try {
            int el;
            this.hfunc = null;
            this.hparamid = null;
            this.docroot = null;
            int docel = decoder.openElement(ElementId.ELEM_DOC);
            while ((el = decoder.peekElement()) != 0) {
                if (el == ElementId.ELEM_FUNCTION.id()) {
                    if (this.hfunc == null) {
                        this.hfunc = new HighFunction(this.function, this.language, this.compilerSpec, this.dtmanage);
                        this.hfunc.decode(decoder);
                        continue;
                    }
                    this.docroot = ClangMarkup.buildClangTree(decoder, this.hfunc);
                    if (this.docroot != null) continue;
                    this.errMsg = "Unable to decode C markup";
                    continue;
                }
                if (el == ElementId.ELEM_PARAMMEASURES.id()) {
                    this.hparamid = new HighParamID(this.function, this.language, this.compilerSpec, this.dtmanage);
                    this.hparamid.decode(decoder);
                    continue;
                }
                this.errMsg = "Unknown decompiler tag";
                return;
            }
            decoder.closeElement(docel);
        }
        catch (DecoderException e) {
            this.errMsg = e.getMessage();
            this.hfunc = null;
            this.hparamid = null;
            return;
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            this.hfunc = null;
            this.hparamid = null;
            return;
        }
    }
}

