/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class CodeUnitCountSettingsDefinition
implements EnumSettingsDefinition {
    private static final String CODE_UNIT_COUNT = "Code-unit count";
    public static final CodeUnitCountSettingsDefinition DEF = new CodeUnitCountSettingsDefinition();
    public static final int MAX_CODE_UNIT_COUNT = 8;
    private static final String[] choices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};

    private CodeUnitCountSettingsDefinition() {
    }

    public int getCount(Settings settings) {
        return this.getChoice(settings) + 1;
    }

    public void setCount(Settings settings, int count) {
        if (count < 1) {
            settings.clearSetting(CODE_UNIT_COUNT);
        } else {
            if (count > 8) {
                count = 8;
            }
            settings.setLong(CODE_UNIT_COUNT, (long)(count - 1));
        }
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(CODE_UNIT_COUNT);
        if (value == null || value < 0L || value >= (long)choices.length) {
            return 0;
        }
        return value.intValue();
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0) {
            settings.clearSetting(CODE_UNIT_COUNT);
        } else {
            if (value > choices.length - 1) {
                value = choices.length - 1;
            }
            settings.setLong(CODE_UNIT_COUNT, (long)value);
        }
    }

    public String getDisplayValue(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return CODE_UNIT_COUNT;
    }

    public String getStorageKey() {
        return CODE_UNIT_COUNT;
    }

    public String getDescription() {
        return "Selects the number of bytes to display";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(CODE_UNIT_COUNT);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(CODE_UNIT_COUNT);
        if (l == null) {
            destSettings.clearSetting(CODE_UNIT_COUNT);
        } else {
            destSettings.setLong(CODE_UNIT_COUNT, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(CODE_UNIT_COUNT) != null;
    }
}

