/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.GFile;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class FSBDirNode
extends FSBFileNode {
    FSBDirNode(GFile dirFile) {
        super(dirFile);
    }

    @Override
    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        try {
            return FSBNode.createNodesFromFileList(this.file.getListing(), monitor);
        }
        catch (IOException iOException) {
            return List.of();
        }
    }

    @Override
    public void updateFileAttributes(TaskMonitor monitor) {
        for (GTreeNode node : this.getChildren()) {
            if (node instanceof FSBFileNode) {
                ((FSBFileNode)node).updateFileAttributes(monitor);
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        super.updateFileAttributes(monitor);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

