/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.IntelHexMemImage;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.app.util.opinion.MotorolaHexLoader;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IntelHexLoader
extends AbstractProgramLoader {
    public static final String INTEL_HEX_NAME = "Intel Hex";
    private static final String OPTION_NAME_BASE_ADDRESS = "Base Address";
    private static final String OPTION_NAME_BLOCK_NAME = "Block Name";
    private static final String OPTION_NAME_IS_OVERLAY = "Overlay";

    @Override
    public LoaderTier getTier() {
        return LoaderTier.UNTARGETED_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (MotorolaHexLoader.isPossibleHexFile(provider)) {
            List languageDescriptions = this.getLanguageService().getLanguageDescriptions(false);
            for (LanguageDescription languageDescription : languageDescriptions) {
                Collection compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
                for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                    LanguageCompilerSpecPair lcs = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID());
                    loadSpecs.add(new LoadSpec(this, 0L, lcs, false));
                }
            }
        }
        return loadSpecs;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        Address baseAddr = null;
        for (Option option : options) {
            String optName = option.getName();
            try {
                if (optName.equals(OPTION_NAME_BASE_ADDRESS)) {
                    baseAddr = (Address)option.getValue();
                    if (baseAddr != null) continue;
                    return "Invalid base address";
                }
                if (optName.equals(OPTION_NAME_BLOCK_NAME)) {
                    if (String.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Block Name must be a String";
                }
                if (optName.equals(OPTION_NAME_IS_OVERLAY)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Overlay must be a boolean";
                }
                return "Unknown option: " + optName;
            }
            catch (ClassCastException e) {
                return "Invalid type for option: " + optName + " - " + e.getMessage();
            }
        }
        return null;
    }

    private Address getBaseAddr(List<Option> options) {
        Address baseAddr = null;
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_BASE_ADDRESS)) continue;
            baseAddr = (Address)option.getValue();
        }
        return baseAddr;
    }

    private String getBlockName(List<Option> options) {
        String blockName = "";
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_BLOCK_NAME)) continue;
            blockName = (String)option.getValue();
        }
        return blockName;
    }

    private boolean isOverlay(List<Option> options) {
        boolean isOverlay = false;
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_IS_OVERLAY)) continue;
            isOverlay = (Boolean)option.getValue();
        }
        return isOverlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String programName, Project project, String programFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws IOException, CancelledException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language importerLanguage = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec importerCompilerSpec = importerLanguage.getCompilerSpecByID(pair.compilerSpecID);
        Program prog = this.createProgram(provider, programName, null, this.getName(), importerLanguage, importerCompilerSpec, consumer);
        List<Loaded<Program>> loadedList = List.of(new Loaded<Program>(prog, programName, programFolderPath));
        boolean success = false;
        try {
            this.loadInto(provider, loadSpec, options, log, prog, monitor);
            this.createDefaultMemoryBlocks(prog, importerLanguage, log);
            success = true;
            List<Loaded<Program>> list = loadedList;
            return list;
        }
        finally {
            if (!success) {
                this.release(loadedList, consumer);
            }
        }
    }

    @Override
    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        Address baseAddr = this.getBaseAddr(options);
        if (baseAddr == null) {
            baseAddr = prog.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        }
        try {
            this.processIntelHex(provider, options, log, prog, monitor);
        }
        catch (AddressOverflowException e) {
            throw new LoadException("Hex file specifies range greater than allowed address space - " + e.getMessage());
        }
    }

    private void processIntelHex(ByteProvider provider, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws IOException, AddressOverflowException, CancelledException {
        String blockName = this.getBlockName(options);
        boolean isOverlay = this.isOverlay(options);
        Address baseAddr = this.getBaseAddr(options);
        if (baseAddr == null) {
            baseAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        }
        if (blockName == null || blockName.length() == 0) {
            blockName = this.generateBlockName(program, isOverlay, baseAddr.getAddressSpace());
        }
        String line = null;
        int lineNum = 0;
        IntelHexMemImage memImage = new IntelHexMemImage(program.getAddressFactory().getDefaultAddressSpace(), baseAddr);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(provider.getInputStream(0L)));){
            while ((line = in.readLine()) != null) {
                String msg;
                monitor.checkCancelled();
                if (++lineNum % 1000 == 1) {
                    monitor.setMessage("Reading in ... " + lineNum);
                }
                if ((msg = memImage.parseLine(line)) == null) continue;
                log.appendMsg("Line: " + lineNum + " - " + msg);
            }
        }
        String msg = memImage.createMemory(this.getName(), provider.getName(), blockName, isOverlay, program, monitor);
        if (msg.length() > 0) {
            log.appendMsg(msg);
        }
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
            long startEIP = memImage.getStartEIP();
            int startCS = memImage.getStartCS();
            int startIP = memImage.getStartIP();
            Address entryAddress = null;
            if (startEIP != -1L) {
                entryAddress = space.getAddress(startEIP);
            } else if (startCS != -1 && startIP != -1 && space instanceof SegmentedAddressSpace) {
                SegmentedAddressSpace segSpace = (SegmentedAddressSpace)space;
                entryAddress = segSpace.getAddress(startCS, startIP);
            }
            if (entryAddress != null) {
                this.createSymbol(symbolTable, entryAddress, "entry", true, null);
            }
        }
        catch (Exception e) {
            log.appendMsg("Could not create symbol at entry point: " + e);
        }
    }

    private void createSymbol(SymbolTable symbolTable, Address addr, String name, boolean isEntry, Namespace namespace) throws InvalidInputException {
        if (isEntry) {
            symbolTable.addExternalEntryPoint(addr);
        }
        symbolTable.createLabel(addr, name, namespace, SourceType.IMPORTED);
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        AddressSpace defaultAddressSpace;
        Program program;
        AddressFactory addressFactory;
        String blockName = "";
        boolean isOverlay = false;
        Address baseAddr = null;
        if (domainObject instanceof Program && (addressFactory = (program = (Program)domainObject).getAddressFactory()) != null && (defaultAddressSpace = addressFactory.getDefaultAddressSpace()) != null) {
            baseAddr = defaultAddressSpace.getAddress(0L);
        }
        ArrayList<Option> list = new ArrayList<Option>();
        if (loadIntoProgram) {
            list.add(new Option(OPTION_NAME_IS_OVERLAY, isOverlay));
            list.add(new Option(OPTION_NAME_BLOCK_NAME, blockName));
        } else {
            isOverlay = false;
        }
        if (baseAddr == null) {
            list.add(new Option(OPTION_NAME_BASE_ADDRESS, Address.class));
        } else {
            list.add(new Option(OPTION_NAME_BASE_ADDRESS, baseAddr));
        }
        return list;
    }

    @Override
    public String getName() {
        return INTEL_HEX_NAME;
    }
}

