/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import generic.theme.GThemeDefaults;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TypeDefDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private final TypeDef typeDef;
    private List<String> warningLines;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    private String truncatedHtmlData;

    private TypeDefDataTypeHTMLRepresentation(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines) {
        this.typeDef = typeDef;
        this.warningLines = warningLines;
        this.headerContent = headerLines;
        this.bodyContent = bodyLines;
        List<ValidatableLine> trimmedHeaderContent = this.buildHeaderText(true);
        List<ValidatableLine> trimmedBodyContent = this.buildBodyText(this.getBaseDataType(), true);
        this.truncatedHtmlData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, warningLines, trimmedHeaderContent, trimmedBodyContent, true);
    }

    public TypeDefDataTypeHTMLRepresentation(TypeDef typeDef) {
        this.typeDef = typeDef;
        this.warningLines = this.buildWarnings();
        this.headerContent = this.buildHeaderText(false);
        this.bodyContent = this.buildBodyText(this.getBaseDataType(), false);
        this.originalHTMLData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, this.warningLines, this.headerContent, this.bodyContent, false);
        List<ValidatableLine> trimmedHeaderContent = this.buildHeaderText(true);
        List<ValidatableLine> trimmedBodyContent = this.buildBodyText(this.getBaseDataType(), true);
        this.truncatedHtmlData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, this.warningLines, trimmedHeaderContent, trimmedBodyContent, true);
    }

    private DataType getBaseDataType() {
        TypeDef baseDataType = this.typeDef;
        while (!(baseDataType instanceof BuiltInDataType) && baseDataType instanceof TypeDef) {
            TypeDef td = baseDataType;
            baseDataType = TypeDefDataTypeHTMLRepresentation.getBasePointerArrayDataType(td.getDataType());
        }
        return baseDataType;
    }

    private static DataType getBasePointerArrayDataType(DataType dt) {
        while (dt instanceof Pointer || dt instanceof Array) {
            if (dt instanceof Pointer) {
                dt = ((Pointer)dt).getDataType();
                continue;
            }
            dt = ((Array)dt).getDataType();
        }
        return dt;
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + this.truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return this.truncatedHtmlData;
    }

    protected List<String> buildWarnings() {
        DataType baseType = this.typeDef.getBaseDataType();
        if (!(baseType instanceof Composite) || !baseType.isZeroLength()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("WARNING! Refers to Empty " + (baseType instanceof Structure ? "Structure" : "Union"));
        return list;
    }

    @Override
    protected TextLine buildFooterText(DataType dataType) {
        if (dataType.isZeroLength()) {
            return new TextLine("0");
        }
        return super.buildFooterText(dataType);
    }

    private String getDataTypeNameHTML(TypeDef td, boolean trim) {
        String name = td.getName();
        if (trim) {
            name = TypeDefDataTypeHTMLRepresentation.truncateAsNecessary(name);
        }
        name = HTMLUtilities.friendlyEncodeHTML((String)name);
        StringBuilder buffy = new StringBuilder("<TT>");
        if (td.isAutoNamed()) {
            buffy.append("auto-typedef ");
            buffy.append(name);
        } else {
            buffy.append("typedef ");
            buffy.append(td != this.typeDef ? TypeDefDataTypeHTMLRepresentation.generateTypeName((DataType)td, null, trim) : name);
            buffy.append(" ");
            buffy.append(TypeDefDataTypeHTMLRepresentation.generateTypeName(td.getDataType(), null, trim));
        }
        buffy.append("</TT>").append("<BR>");
        return buffy.toString();
    }

    protected List<ValidatableLine> buildHeaderText(boolean trim) {
        DataType baseDataType = this.typeDef.getDataType();
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        lines.add(new TextLine(this.getDataTypeNameHTML(this.typeDef, trim)));
        if (!this.typeDef.isAutoNamed()) {
            StringBuilder buffy = new StringBuilder();
            Settings defaultSettings = this.typeDef.getDefaultSettings();
            for (SettingsDefinition settingsDef : this.typeDef.getSettingsDefinitions()) {
                if (!(settingsDef instanceof TypeDefSettingsDefinition) || !settingsDef.hasValue(defaultSettings)) continue;
                if (buffy.length() == 0) {
                    buffy.append("<DIV STYLE='margin-left: 10px;'>");
                } else {
                    buffy.append("<BR>");
                }
                buffy.append("<TT>").append(settingsDef.getName()).append(": ").append(settingsDef.getValueString(defaultSettings));
                buffy.append("</TT>");
            }
            if (buffy.length() != 0) {
                buffy.append("</DIV>");
                lines.add(new TextLine(buffy.toString()));
            }
        }
        if ((baseDataType = this.typeDef.getBaseDataType()) instanceof Pointer || baseDataType instanceof Array) {
            String lengthAndAlignmentStr = TypeDefDataTypeHTMLRepresentation.addDataTypeLengthAndAlignment((DataType)this.typeDef, new StringBuilder()).toString();
            lines.add(new TextLine("<DIV STYLE='margin-left: 10px;'>" + lengthAndAlignmentStr + "</DIV>"));
        }
        baseDataType = TypeDefDataTypeHTMLRepresentation.getBasePointerArrayDataType(baseDataType);
        boolean firstBaseTypedef = true;
        while (baseDataType instanceof TypeDef) {
            TypeDef td = (TypeDef)baseDataType;
            if (!td.isAutoNamed()) {
                String br = "";
                if (firstBaseTypedef) {
                    br = "<BR>";
                    firstBaseTypedef = false;
                }
                lines.add(new TextLine(br + this.getDataTypeNameHTML(td, trim)));
            }
            baseDataType = TypeDefDataTypeHTMLRepresentation.getBasePointerArrayDataType(td.getDataType());
        }
        return lines;
    }

    private List<ValidatableLine> buildBodyText(DataType baseDataType, boolean trim) {
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        if (baseDataType instanceof BuiltInDataType) {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBuiltIn(lines, baseDataType);
        } else if (baseDataType != null) {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBaseDataType(lines, baseDataType, trim);
        }
        return lines;
    }

    private static String buildHTMLText(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines, boolean trim) {
        StringBuilder buffy = new StringBuilder();
        for (String warning : warningLines) {
            String string = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(warning, (Color)GThemeDefaults.Colors.Messages.ERROR);
            buffy.append(string).append("<BR>");
        }
        for (TextLine textLine : headerLines) {
            String headerLine = textLine.getText();
            if (trim) {
                headerLine = TypeDefDataTypeHTMLRepresentation.truncateAsNecessary(headerLine, 80);
            }
            headerLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(headerLine);
        }
        buffy.append("<BR>");
        for (TextLine textLine : bodyLines) {
            String bodyLine = textLine.getText();
            bodyLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(bodyLine);
        }
        return buffy.toString();
    }

    private static void buildHTMLTextForBuiltIn(List<ValidatableLine> lines, DataType baseDataType) {
        lines.add(new TextLine("<TT>"));
        String encodedName = HTMLUtilities.friendlyEncodeHTML((String)baseDataType.getDisplayName());
        lines.add(new TextLine(encodedName));
        lines.add(new TextLine("</TT>"));
        lines.add(new TextLine("<BR>"));
        lines.add(new TextLine("<DIV STYLE='margin-left: 10px;'>"));
        String description = baseDataType.getDescription();
        if (!StringUtils.isBlank((CharSequence)description)) {
            String encodedDescription = HTMLUtilities.friendlyEncodeHTML((String)description);
            lines.add(new TextLine(encodedDescription));
            lines.add(new TextLine("<BR>"));
        }
        lines.add(new TextLine(TypeDefDataTypeHTMLRepresentation.addDataTypeLengthAndAlignment(baseDataType, new StringBuilder()).toString()));
        lines.add(new TextLine("</DIV>"));
    }

    private static void buildHTMLTextForBaseDataType(List<ValidatableLine> lines, DataType baseDataType, boolean trim) {
        HTMLDataTypeRepresentation baseRepresentation = ToolTipUtils.getHTMLRepresentation(baseDataType);
        String baseHTML = baseRepresentation.getFullHTMLContentString();
        if (trim) {
            baseHTML = baseRepresentation.getHTMLContentString();
        }
        lines.add(new TextLine(baseHTML));
        if (baseHTML.indexOf("Length: ") < 0 && baseDataType.getLength() >= 0) {
            StringBuilder buffy = new StringBuilder();
            TypeDefDataTypeHTMLRepresentation.addDataTypeLengthAndAlignment(baseDataType, buffy);
            lines.add(new TextLine(buffy.toString()));
        }
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof TypeDefDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        TypeDefDataTypeHTMLRepresentation typeDefRepresentation = (TypeDefDataTypeHTMLRepresentation)otherRepresentation;
        DataType myBaseDataType = this.getBaseDataType();
        DataType otherBaseDataType = typeDefRepresentation.getBaseDataType();
        HTMLDataTypeRepresentation myBaseRepresentation = ToolTipUtils.getHTMLRepresentation(myBaseDataType);
        HTMLDataTypeRepresentation otherBaseRepresentation = ToolTipUtils.getHTMLRepresentation(otherBaseDataType);
        HTMLDataTypeRepresentation[] diffs = this.doDiff(myBaseRepresentation, otherBaseRepresentation);
        ArrayList<ValidatableLine> header = new ArrayList<ValidatableLine>(this.headerContent);
        ArrayList<ValidatableLine> body = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            body.add(new TextLine(diffs[0].getFullHTMLContentString()));
        }
        ArrayList<ValidatableLine> otherHeader = new ArrayList<ValidatableLine>(typeDefRepresentation.headerContent);
        ArrayList<ValidatableLine> otherBody = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            otherBody.add(new TextLine(diffs[1].getFullHTMLContentString()));
        }
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        List<String> noWarnings = Collections.emptyList();
        return new HTMLDataTypeRepresentation[]{new TypeDefDataTypeHTMLRepresentation(this.typeDef, noWarnings, headerDiff.getLeftLines(), body), new TypeDefDataTypeHTMLRepresentation(typeDefRepresentation.typeDef, noWarnings, headerDiff.getRightLines(), otherBody)};
    }

    private HTMLDataTypeRepresentation[] doDiff(HTMLDataTypeRepresentation myBaseRepresentation, HTMLDataTypeRepresentation otherBaseRepresentation) {
        HTMLDataTypeRepresentation[] diffs = myBaseRepresentation.diff(otherBaseRepresentation);
        return diffs;
    }
}

