/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import generic.theme.GThemeDefaults;
import ghidra.app.util.html.DataTypeLine;
import ghidra.app.util.html.EmptyDataTypeLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentationDiffInput;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.app.util.html.diff.DiffLines;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private static final int MAX_COMPONENT_COUNT = 1000;
    private static final int MAX_LINE_COUNT = 15;
    protected List<String> warningLines;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    protected TextLine footerText;
    protected TextLine displayName;
    protected List<ValidatableLine> alignmentText;
    protected TextLine alignmentValueText;
    private String truncatedHtmlData;

    protected CompositeDataTypeHTMLRepresentation(List<String> warningLines, List<ValidatableLine> header, List<ValidatableLine> bodyContent, List<ValidatableLine> alignmentText, TextLine footerText, TextLine displayName, TextLine alignmentValue) {
        this.warningLines = warningLines;
        this.headerContent = header;
        this.bodyContent = bodyContent;
        this.footerText = footerText;
        this.displayName = displayName;
        this.alignmentText = alignmentText;
        this.alignmentValueText = alignmentValue;
        this.originalHTMLData = this.buildHTMLText(false);
        this.truncatedHtmlData = this.buildHTMLText(true);
    }

    public CompositeDataTypeHTMLRepresentation(Composite comp) {
        this.warningLines = this.buildWarnings(comp);
        this.headerContent = this.buildHeaderText((DataType)comp);
        this.bodyContent = this.buildContent(comp);
        this.alignmentText = this.buildAlignmentText(comp);
        this.footerText = this.buildFooterText((DataType)comp);
        String type = "";
        if (comp instanceof Union) {
            type = "union ";
        } else if (comp instanceof Structure) {
            type = "struct ";
        }
        this.displayName = new TextLine(type + comp.getDisplayName() + " ");
        this.alignmentValueText = this.buildAlignmentValueText(comp);
        this.originalHTMLData = this.buildHTMLText(false);
        this.truncatedHtmlData = this.buildHTMLText(true);
    }

    protected List<String> buildWarnings(Composite comp) {
        if (!comp.isZeroLength()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("WARNING! Empty " + (comp instanceof Structure ? "Structure" : "Union"));
        return list;
    }

    protected List<ValidatableLine> buildAlignmentText(Composite dataType) {
        String packStr;
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>();
        String alignStr = CompositeInternal.getMinAlignmentString((Composite)dataType);
        if (alignStr != null && alignStr.length() != 0) {
            list.add(new TextLine(alignStr));
        }
        if ((packStr = CompositeInternal.getPackingString((Composite)dataType)) != null && packStr.length() != 0) {
            list.add(new TextLine(packStr));
        }
        return list;
    }

    protected TextLine buildAlignmentValueText(Composite composite) {
        return new TextLine("" + composite.getAlignment());
    }

    private List<ValidatableLine> buildContent(Composite comp) {
        DataTypeComponent[] components;
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>();
        int count = 0;
        boolean showPadding = comp instanceof Structure && !comp.isPackingEnabled();
        int nextPadStart = 0;
        int length = comp.isZeroLength() ? 0 : comp.getLength();
        for (DataTypeComponent dataTypeComponent : components = comp.getDefinedComponents()) {
            int offset = dataTypeComponent.getOffset();
            if (showPadding && offset > nextPadStart) {
                int padLen = offset - nextPadStart;
                list.add(new TextLine("-- " + padLen + " undefined bytes at offset 0x" + Long.toHexString(nextPadStart) + " --"));
            }
            nextPadStart = dataTypeComponent.getEndOffset() + 1;
            String fieldName = dataTypeComponent.getFieldName();
            String comment = dataTypeComponent.getComment();
            DataType dataType = dataTypeComponent.getDataType();
            String type = "<unknown type>";
            if (dataType != null) {
                type = dataType.getDisplayName();
            }
            list.add(new DataTypeLine(fieldName, type, comment, dataType));
            if (count++ < 1000) continue;
            list.add(new DataTypeLine("", "Warning: Too many components to display...", "", null));
            break;
        }
        if (showPadding && length > nextPadStart) {
            int padLen = length - nextPadStart;
            list.add(new TextLine("-- " + padLen + " undefined bytes at offset 0x" + Long.toHexString(nextPadStart) + " --"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private String buildHTMLText(boolean trim) {
        void var7_12;
        StringBuilder fullHtml = new StringBuilder();
        StringBuilder truncatedHtml = new StringBuilder();
        int lineCount = 0;
        for (String warning : this.warningLines) {
            String string = CompositeDataTypeHTMLRepresentation.wrapStringInColor(warning, (Color)GThemeDefaults.Colors.Messages.ERROR);
            CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, string, "<BR>");
        }
        for (TextLine textLine : this.headerContent) {
            String text = textLine.getText();
            if (trim) {
                text = CompositeDataTypeHTMLRepresentation.truncateAsNecessary(text);
            }
            String headerLine = CompositeDataTypeHTMLRepresentation.wrapStringInColor(text, textLine.getTextColor());
            CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, headerLine);
        }
        String string = this.displayName.getText();
        if (trim) {
            String string2 = StringUtilities.trimMiddle((String)string, (int)80);
        }
        String displayNameText = HTMLUtilities.friendlyEncodeHTML((String)var7_12);
        displayNameText = CompositeDataTypeHTMLRepresentation.wrapStringInColor(displayNameText, this.displayName.getTextColor());
        CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, "<TT>", displayNameText, "</TT>", "<BR>");
        CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, "<DIV STYLE='margin-left: 10px;'>", "Length: ", this.footerText.getText(), "&nbsp;", "&nbsp;", "Alignment: ", this.alignmentValueText.getText(), "</DIV>");
        CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, "{", "<BR>");
        String tableOpen = "<TABLE BORDER=0 CELLSPACING=5 CELLPADDING=0>";
        fullHtml.append(tableOpen);
        truncatedHtml.append(tableOpen);
        Iterator<ValidatableLine> iterator = this.bodyContent.iterator();
        while (iterator.hasNext()) {
            StringBuilder lineBuffer = new StringBuilder();
            ValidatableLine line = iterator.next();
            if (!(line instanceof DataTypeLine)) {
                CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, "<TR>", "<TD COLSPAN=3><FONT COLOR=\"" + GThemeDefaults.Colors.Palette.GRAY + "\">", TAB, TAB, line.getText(), "</FONT>", "</TD>", "</TR>");
                continue;
            }
            DataTypeLine dataTypeLine = (DataTypeLine)line;
            String typeName = CompositeDataTypeHTMLRepresentation.generateTypeName(dataTypeLine, trim);
            int fieldLength = 40;
            String fieldName = dataTypeLine.getName();
            if (trim) {
                fieldName = StringUtilities.trimMiddle((String)fieldName, (int)fieldLength);
            }
            fieldName = HTMLUtilities.friendlyEncodeHTML((String)fieldName);
            fieldName = CompositeDataTypeHTMLRepresentation.wrapStringInColor(fieldName, dataTypeLine.getNameColor());
            String typeComment = dataTypeLine.getComment();
            if (trim) {
                typeComment = CompositeDataTypeHTMLRepresentation.truncateAsNecessary(typeComment, fieldLength);
            }
            typeComment = HTMLUtilities.friendlyEncodeHTML((String)typeComment);
            typeComment = CompositeDataTypeHTMLRepresentation.wrapStringInColor(typeComment, dataTypeLine.getCommentColor());
            lineBuffer.append("<TR>");
            lineBuffer.append("<TD ALIGN=LEFT VALIGN=TOP>").append("<TT>").append(TAB).append(typeName).append("</TT>").append("</TD>");
            lineBuffer.append("<TD ALIGN=LEFT VALIGN=TOP>").append("&nbsp;").append(fieldName).append("</TD>");
            lineBuffer.append("<TD ALIGN=LEFT VALIGN=TOP>").append("&nbsp;").append(typeComment).append("&nbsp;").append("</TD>");
            lineBuffer.append("</TR>");
            String lineString = lineBuffer.toString();
            CompositeDataTypeHTMLRepresentation.append(fullHtml, truncatedHtml, lineCount++, lineString);
        }
        if (lineCount >= 15) {
            truncatedHtml.append(TAB).append("...").append("<BR>");
        }
        Object alignmentLine = "";
        for (TextLine textLine : this.alignmentText) {
            alignmentLine = (String)alignmentLine + "&nbsp;" + CompositeDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("</TABLE>").append("}").append("<TT>").append((String)alignmentLine).append("</TT>").append("<BR>");
        String trailingString = stringBuilder.toString();
        fullHtml.append(trailingString);
        truncatedHtml.append(trailingString);
        if (trim) {
            return truncatedHtml.toString();
        }
        return fullHtml.toString();
    }

    private static void append(StringBuilder fullHtml, StringBuilder truncatedHtml, int lineCount, String ... content) {
        for (String string : content) {
            fullHtml.append(string);
        }
        CompositeDataTypeHTMLRepresentation.maybeAppend(truncatedHtml, lineCount, content);
    }

    private static void maybeAppend(StringBuilder buffer, int lineCount, String ... content) {
        if (lineCount > 15) {
            return;
        }
        for (String string : content) {
            buffer.append(string);
        }
    }

    private static String generateTypeName(DataTypeLine line, boolean trim) {
        Color color = line.getTypeColor();
        DataType dt = line.getDataType();
        if (dt != null) {
            return CompositeDataTypeHTMLRepresentation.generateTypeName(dt, color, trim);
        }
        String type = CompositeDataTypeHTMLRepresentation.truncateAsNecessary(line.getType());
        type = HTMLUtilities.friendlyEncodeHTML((String)type);
        return CompositeDataTypeHTMLRepresentation.wrapStringInColor(type, color);
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + this.truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return this.truncatedHtmlData;
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        return new EmptyDataTypeLine();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof CompositeDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        CompositeDataTypeHTMLRepresentation compositeRepresentation = (CompositeDataTypeHTMLRepresentation)otherRepresentation;
        List<ValidatableLine> header = this.copyLines(this.headerContent);
        List<ValidatableLine> body = this.copyLines(this.bodyContent);
        TextLine name = new TextLine(this.displayName.getText());
        List<ValidatableLine> alignment = this.copyLines(this.alignmentText);
        List<ValidatableLine> otherHeader = this.copyLines(compositeRepresentation.headerContent);
        List<ValidatableLine> otherBody = this.copyLines(compositeRepresentation.bodyContent);
        TextLine otherName = new TextLine(compositeRepresentation.displayName.getText());
        List<ValidatableLine> otherAlignment = this.copyLines(compositeRepresentation.alignmentText);
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff bodyDiff = DataTypeDiffBuilder.diffBody(this.getDiffInput(body), this.getDiffInput(otherBody));
        this.diffTextLine(name, otherName);
        this.diffAlignment(alignment, otherAlignment);
        List<String> noWarnings = Collections.emptyList();
        return new HTMLDataTypeRepresentation[]{new CompositeDataTypeHTMLRepresentation(noWarnings, headerDiff.getLeftLines(), bodyDiff.getLeftLines(), alignment, this.footerText, name, this.alignmentValueText), new CompositeDataTypeHTMLRepresentation(noWarnings, headerDiff.getRightLines(), bodyDiff.getRightLines(), otherAlignment, compositeRepresentation.footerText, otherName, compositeRepresentation.alignmentValueText)};
    }

    protected void diffAlignment(List<ValidatableLine> myLines, List<ValidatableLine> otherLines) {
        HTMLDataTypeRepresentationDiffInput myInput = this.getDiffInput(myLines);
        HTMLDataTypeRepresentationDiffInput otherInput = this.getDiffInput(otherLines);
        DiffLines mine = new DiffLines(myInput);
        DiffLines other = new DiffLines(otherInput);
        DataTypeDiffBuilder.padLines(mine, other);
        DataTypeDiffBuilder.highlightDifferences(mine, other);
    }
}

