/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import utilities.util.FileUtilities;

public class OriginalFileExporter
extends Exporter {
    private static final String USER_MODS_OPTION_NAME = "Export User Byte Modifications";
    private static final boolean USER_MODS_OPTION_DEFAULT = true;
    private static final String CREATE_DIR_OPTION_NAME = "Save Multiple File Sources To Directory";
    private static final boolean CREATE_DIR_OPTION_DEFAULT = false;
    private List<Option> options;

    public OriginalFileExporter() {
        super("Original File", "", new HelpLocation("ExporterPlugin", "original_file"));
    }

    @Override
    public boolean supportsAddressRestrictedExport() {
        return false;
    }

    @Override
    public boolean canExportDomainObject(DomainObject domainObject) {
        if (domainObject instanceof Program) {
            Program program = (Program)domainObject;
            return !program.getMemory().getAllFileBytes().isEmpty();
        }
        return false;
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getSimpleName());
            return false;
        }
        Program program = (Program)domainObj;
        List allFileBytes = program.getMemory().getAllFileBytes();
        if (allFileBytes.isEmpty()) {
            this.log.appendMsg("Exporting a program with no file source bytes is not supported");
            return false;
        }
        File dir = null;
        if (this.shouldCreateDir()) {
            dir = file;
            if (!FileUtilities.mkdirs((File)dir)) {
                this.log.appendMsg("Failed to create directory: " + dir);
                return false;
            }
        } else if (allFileBytes.size() > 1) {
            this.log.appendMsg("WARNING: Program contains more than 1 file source.\nOnly bytes from the primary (first) file source will be exported.\nEnable option to export all file sources to a directory if desired.");
        }
        boolean ret = true;
        for (int i = 0; i < allFileBytes.size(); ++i) {
            FileBytes fileBytes = (FileBytes)allFileBytes.get(i);
            if (dir != null) {
                file = new File(dir, dir.getName() + "." + i);
            }
            boolean success = this.shouldExportUserModifications() ? this.exportModifiedBytes(file, fileBytes, (Program)domainObj, monitor) : this.exportUnmodifiedlBytes(file, fileBytes, monitor);
            ret &= success;
            if (dir == null) break;
            if (success) {
                this.log.appendMsg("Exported " + fileBytes.getFilename() + " to " + file);
                continue;
            }
            this.log.appendMsg("Failed to export " + fileBytes.getFilename() + " to " + file);
        }
        return ret;
    }

    private boolean exportUnmodifiedlBytes(File file, FileBytes fileBytes, TaskMonitor monitor) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            FileUtilities.copyStreamToStream((InputStream)new FileBytesInputStream(fileBytes, false), (OutputStream)out, (TaskMonitor)monitor);
            boolean bl = true;
            return bl;
        }
    }

    private boolean exportModifiedBytes(File file, FileBytes fileBytes, Program program, TaskMonitor monitor) throws IOException {
        File tempFile = File.createTempFile("ghidra_export_", null);
        try (FileOutputStream out = new FileOutputStream(tempFile, false);){
            FileUtilities.copyStreamToStream((InputStream)new FileBytesInputStream(fileBytes, true), (OutputStream)out, (TaskMonitor)monitor);
        }
        try (RandomAccessFile fout = new RandomAccessFile(tempFile, "rw");){
            Iterable relocs = () -> program.getRelocationTable().getRelocations();
            Memory memory = program.getMemory();
            for (Relocation reloc : relocs) {
                long offset;
                Address addr;
                AddressSourceInfo addrSourceInfo;
                if (reloc.getStatus() != Relocation.Status.APPLIED && reloc.getStatus() != Relocation.Status.APPLIED_OTHER || (addrSourceInfo = memory.getAddressSourceInfo(addr = reloc.getAddress())) == null || (offset = addrSourceInfo.getFileOffset()) < 0L) continue;
                MemoryBlockSourceInfo memSourceInfo = addrSourceInfo.getMemoryBlockSourceInfo();
                byte[] bytes = reloc.getBytes();
                if (bytes == null) continue;
                int len = Math.min(bytes.length, (int)memSourceInfo.getMaxAddress().subtract(addr) + 1);
                fout.seek(offset);
                fout.write(bytes, 0, len);
            }
        }
        catch (Exception e) {
            if (!tempFile.delete()) {
                this.log.appendMsg("Failed to delete malformed file: " + tempFile);
            }
            this.log.appendException((Throwable)e);
            return false;
        }
        Path from = Paths.get(tempFile.toURI());
        Path to = Paths.get(file.toURI());
        Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        if (this.options == null) {
            Program program;
            this.options = new ArrayList<Option>();
            this.options.add(new Option(USER_MODS_OPTION_NAME, true));
            DomainObject domainObject = domainObjectService.getDomainObject();
            if (domainObject instanceof Program && (program = (Program)domainObject).getMemory().getAllFileBytes().size() > 1) {
                this.options.add(new Option(CREATE_DIR_OPTION_NAME, false));
            }
        }
        return this.options;
    }

    @Override
    public void setOptions(List<Option> opt) {
        this.options = opt;
    }

    private boolean shouldExportUserModifications() {
        return OptionUtils.getOption(USER_MODS_OPTION_NAME, this.options, true);
    }

    private boolean shouldCreateDir() {
        return OptionUtils.getOption(CREATE_DIR_OPTION_NAME, this.options, false);
    }

    private static class FileBytesInputStream
    extends InputStream {
        private final FileBytes fileBytes;
        private final long size;
        private long pos;
        private boolean useModifiedBytes;

        FileBytesInputStream(FileBytes fileBytes, boolean useModifiedBytes) {
            this.fileBytes = fileBytes;
            this.size = fileBytes.getSize();
            this.pos = 0L;
            this.useModifiedBytes = useModifiedBytes;
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.size) {
                return -1;
            }
            byte b = this.useModifiedBytes ? this.fileBytes.getModifiedByte(this.pos) : this.fileBytes.getOriginalByte(this.pos);
            ++this.pos;
            return Byte.toUnsignedInt(b);
        }
    }
}

