/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ImageCor20Header;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class COMDescriptorDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR";
    private ImageCor20Header header;

    COMDescriptorDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.ntHeader = ntHeader;
        this.processDataDirectory(ntHeader, reader);
    }

    public ImageCor20Header getHeader() {
        return this.header;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        this.header = new ImageCor20Header(this.reader, ptr, this.ntHeader);
        boolean ret = false;
        if (this.ntHeader.shouldParseCliHeaders()) {
            ret = this.header.parse();
        }
        return ret;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException, MemoryAccessException {
        monitor.setMessage("[" + program.getName() + "]: com descriptor(s)...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        DataType dt = this.header.toDataType();
        PeUtils.createData(program, addr, dt, log);
        if (this.hasParsed) {
            this.header.markup(program, isBinary, monitor, log, ntHeader);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new ArrayDataType(BYTE, this.size, 1), "COM", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

