/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfComdatExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfComdefRecord;
import ghidra.app.util.bin.format.omf.OmfCommentRecord;
import ghidra.app.util.bin.format.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.OmfModuleEnd;
import ghidra.app.util.bin.format.omf.OmfNamesRecord;
import ghidra.app.util.bin.format.omf.OmfObsoleteRecord;
import ghidra.app.util.bin.format.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.OmfSymbolRecord;
import ghidra.app.util.bin.format.omf.OmfUnknownRecord;
import ghidra.app.util.bin.format.omf.OmfUnsupportedRecord;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class OmfRecord {
    public static final byte RHEADR = 110;
    public static final byte REGINT = 112;
    public static final byte REDATA = 114;
    public static final byte RIDATA = 116;
    public static final byte OVLDEF = 118;
    public static final byte ENDREC = 120;
    public static final byte BLKDEF = 122;
    public static final byte BLKEND = 124;
    public static final byte DEBSYM = 126;
    public static final byte THEADR = -128;
    public static final byte LHEADR = -126;
    public static final byte PEDATA = -124;
    public static final byte PIDATA = -122;
    public static final byte COMENT = -120;
    public static final byte MODEND = -118;
    public static final byte EXTDEF = -116;
    public static final byte TYPDEF = -114;
    public static final byte PUBDEF = -112;
    public static final byte LOCSYM = -110;
    public static final byte LINNUM = -108;
    public static final byte LNAMES = -106;
    public static final byte SEGDEF = -104;
    public static final byte GRPDEF = -102;
    public static final byte FIXUPP = -100;
    public static final byte LEDATA = -96;
    public static final byte LIDATA = -94;
    public static final byte LIBHED = -92;
    public static final byte LIBNAM = -90;
    public static final byte LIBLOC = -88;
    public static final byte LIBDIC = -86;
    public static final byte COMDEF = -80;
    public static final byte BAKPAT = -78;
    public static final byte LEXTDEF = -76;
    public static final byte LPUBDEF = -74;
    public static final byte LCOMDEF = -72;
    public static final byte CEXTDEF = -68;
    public static final byte COMDAT = -62;
    public static final byte LINSYM = -60;
    public static final byte ALIAS = -58;
    public static final byte NBKPAT = -56;
    public static final byte LLNAMES = -54;
    public static final byte VERNUM = -52;
    public static final byte VENDEXT = -50;
    public static final byte START = -16;
    public static final byte END = -15;
    protected byte recordType;
    protected int recordLength;
    protected long recordOffset;
    protected byte checkSum;

    public byte getRecordType() {
        return this.recordType;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public void readRecordHeader(BinaryReader reader) throws IOException {
        this.recordOffset = reader.getPointerIndex();
        this.recordType = reader.readNextByte();
        this.recordLength = reader.readNextShort() & 0xFFFF;
    }

    public void readCheckSumByte(BinaryReader reader) throws IOException {
        this.checkSum = reader.readNextByte();
    }

    public byte calcCheckSum(BinaryReader reader) throws IOException {
        byte res = reader.readNextByte();
        res = (byte)(res + reader.readNextByte());
        res = (byte)(res + reader.readNextByte());
        for (int i = 0; i < this.recordLength; ++i) {
            res = (byte)(res + reader.readNextByte());
        }
        return res;
    }

    public boolean validCheckSum(BinaryReader reader) throws IOException {
        if (this.checkSum == 0) {
            return true;
        }
        return this.calcCheckSum(reader) == 0;
    }

    public boolean hasBigFields() {
        return (this.recordType & 1) != 0;
    }

    public static int readInt1Or2(BinaryReader reader, boolean isBig) throws IOException {
        if (isBig) {
            return reader.readNextShort() & 0xFFFF;
        }
        return reader.readNextByte() & 0xFF;
    }

    public static int readInt2Or4(BinaryReader reader, boolean isBig) throws IOException {
        if (isBig) {
            return reader.readNextInt();
        }
        return reader.readNextShort() & 0xFFFF;
    }

    public static int readIndex(BinaryReader reader) throws IOException {
        int firstByte = reader.readNextByte();
        int indexWord = (firstByte & 0x80) != 0 ? (firstByte & 0x7F) * 256 + (reader.readNextByte() & 0xFF) : firstByte;
        return indexWord;
    }

    public static OmfRecord readRecord(BinaryReader reader) throws IOException, OmfException {
        byte type = reader.peekNextByte();
        type = (byte)(type & 0xFE);
        return switch (type) {
            case -128, -126 -> new OmfFileHeader(reader);
            case -120 -> new OmfCommentRecord(reader);
            case -118 -> new OmfModuleEnd(reader);
            case -116 -> new OmfExternalSymbol(reader, false);
            case -112 -> new OmfSymbolRecord(reader, false);
            case -106 -> new OmfNamesRecord(reader);
            case -104 -> new OmfSegmentHeader(reader);
            case -102 -> new OmfGroupRecord(reader);
            case -100 -> new OmfFixupRecord(reader);
            case -96 -> new OmfEnumeratedData(reader);
            case -94 -> new OmfIteratedData(reader);
            case -80 -> new OmfComdefRecord(reader, false);
            case -76 -> new OmfExternalSymbol(reader, true);
            case -74 -> new OmfSymbolRecord(reader, true);
            case -72 -> new OmfComdefRecord(reader, true);
            case -68 -> new OmfComdatExternalSymbol(reader);
            case -124, -122, -108, -92, -90, -88, -86, 110, 112, 114, 116, 118, 120, 122, 124, 126 -> new OmfObsoleteRecord(reader);
            case -114, -110, -78, -62, -60, -58, -56, -54, -52, -50 -> new OmfUnsupportedRecord(reader);
            default -> new OmfUnknownRecord(reader);
        };
    }

    public static String readString(BinaryReader reader) throws IOException {
        int count = reader.readNextByte() & 0xFF;
        return reader.readNextAsciiString(count);
    }

    public static final String getRecordName(int type) {
        for (Field field : OmfRecord.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            try {
                Byte value = (Byte)field.get(null);
                if (type != value) continue;
                return field.getName();
            }
            catch (Exception e) {
                break;
            }
        }
        return "<UNKNOWN>";
    }

    public String toString() {
        return String.format("name: %s, type: 0x%x, offset: 0x%x, length: 0x%x", OmfRecord.getRecordName(this.recordType & 0xFFFFFFFE), this.recordType, this.recordOffset, this.recordLength);
    }
}

