/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;

class AnsiParser {
    private static final String CSI_PARAM_EXPR = "[\\x30-\\x3F]*";
    private static final String CSI_INTER_EXPR = "[\\x20-\\x2F]*";
    private static final String CSI_FINAL_EXPR = "[\\x40-\\x7E]";
    private static final String CSI_MATCH_EXPR = String.format("\\x1b\\[(?<CSIPARAM>%s)(?<CSIINTER>%s)(?<CSIFINAL>%s)", "[\\x30-\\x3F]*", "[\\x20-\\x2F]*", "[\\x40-\\x7E]");
    private static final String CSI_TAIL_EXPR = String.format("\\x1b(?:\\[(?:%s(?:%s)?)?)?\\z", "[\\x30-\\x3F]*", "[\\x20-\\x2F]*");
    private static final String OSC_PARAM_EXPR = "[\\x20-\\x7F]*";
    private static final String OSC_MATCH_EXPR = String.format("\\x1b\\](?<OSCPARAM>%s)(?:\\x07|\\x1b\\\\)", "[\\x20-\\x7F]*");
    private static final String OSC_TAIL_EXPR = String.format("\\x1b(?:\\](?:%s(?:\\x1b)?)?)?\\z", "[\\x20-\\x7F]*");
    private static final Pattern CTRL_SEQ = Pattern.compile(String.format("(?<CSI>%s)|(?<OSC>%s)|(?<NUL>\\x00)", CSI_MATCH_EXPR, OSC_MATCH_EXPR));
    private static final Pattern CTRL_TAIL = Pattern.compile(String.format("%s|%s", CSI_TAIL_EXPR, OSC_TAIL_EXPR));
    private final StringBuffer sb = new StringBuffer();
    private final AnsiParserHandler handler;

    public AnsiParser(AnsiParserHandler handler) {
        this.handler = handler;
    }

    public void processString(String text) throws BadLocationException {
        this.sb.append(text);
        Matcher m = CTRL_SEQ.matcher(this.sb);
        int lastPos = 0;
        while (m.find()) {
            if (m.start() > lastPos) {
                this.handler.handleString(this.sb.substring(lastPos, m.start()));
            }
            if (m.group("CSI") != null) {
                this.handler.handleCSI(m.group("CSIPARAM"), m.group("CSIINTER"), m.group("CSIFINAL"));
            } else if (m.group("OSC") != null) {
                this.handler.handleOSC(m.group("OSCPARAM"));
            } else if (m.group("NUL") != null) {
                // empty if block
            }
            lastPos = m.end();
        }
        m = CTRL_TAIL.matcher(this.sb);
        if (m.find(lastPos)) {
            if (lastPos < m.start()) {
                this.handler.handleString(this.sb.substring(lastPos, m.start()));
            }
            this.sb.delete(0, m.start());
        } else {
            if (lastPos < this.sb.length()) {
                this.handler.handleString(this.sb.substring(lastPos));
            }
            this.sb.setLength(0);
        }
    }

    static interface AnsiParserHandler {
        default public void handleString(String text) throws BadLocationException {
        }

        default public void handleCSI(String param, String inter, String finalChar) throws BadLocationException {
        }

        default public void handleOSC(String param) throws BadLocationException {
        }
    }
}

