/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.label.GLabel;
import docking.widgets.textfield.HintTextField;
import generic.theme.GThemeDefaults;
import ghidra.app.cmd.function.CreateFunctionTagCmd;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.function.tags.AllFunctionsPanel;
import ghidra.app.plugin.core.function.tags.FunctionTagButtonPanel;
import ghidra.app.plugin.core.function.tags.FunctionTagLoader;
import ghidra.app.plugin.core.function.tags.FunctionTagPlugin;
import ghidra.app.plugin.core.function.tags.SourceTagsPanel;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.app.plugin.core.function.tags.TargetTagsPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public class FunctionTagProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    private SourceTagsPanel sourcePanel;
    private TargetTagsPanel targetPanel;
    private FunctionTagButtonPanel buttonPanel;
    private AllFunctionsPanel allFunctionsPanel;
    private Program program;
    private JPanel mainPanel;
    private JPanel inputPanel;
    private HintTextField tagInputField;
    private int MIN_WIDTH = 850;
    private int MIN_HEIGHT = 350;
    private SwingUpdateManager updater = new SwingUpdateManager(this::doUpdate);
    private ProgramLocation currentLocation = null;
    private static final String INPUT_DELIMITER = ",";
    private static String TAG_FILE = "functionTags.xml";
    private Set<FunctionTag> tagsFromFile;

    public FunctionTagProvider(FunctionTagPlugin plugin, Program program) {
        super(plugin.getTool(), "Function Tags", plugin.getName(), ProgramActionContext.class);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.program = program;
        this.mainPanel = this.createWorkPanel();
        this.addToTool();
    }

    public void componentShown() {
        this.updateView();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void locationChanged(ProgramLocation loc) {
        this.currentLocation = loc;
        this.updateView();
    }

    public void programActivated(Program activatedProgram) {
        this.program = activatedProgram;
        activatedProgram.addListener((DomainObjectListener)this);
        this.updateTagViews();
    }

    public void programDeactivated(Program deactivatedProgram) {
        deactivatedProgram.removeListener((DomainObjectListener)this);
        this.program = null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        if (ev.containsEvent(4) || ev.containsEvent(148) || ev.containsEvent(149) || ev.containsEvent(157) || ev.containsEvent(156)) {
            this.updater.updateLater();
            return;
        }
        if (ev.containsEvent(147)) {
            this.repaint();
        }
    }

    private void doUpdate() {
        this.reload();
    }

    private void reload() {
        this.allFunctionsPanel.refresh();
        Function function = this.getFunction(this.currentLocation);
        this.sourcePanel.refresh(function);
        this.targetPanel.refresh(function);
    }

    private void updateView() {
        this.updateTitle(this.currentLocation);
        this.updateTagViews();
    }

    private void repaint() {
        this.sourcePanel.repaint();
        this.targetPanel.repaint();
        this.allFunctionsPanel.repaint();
    }

    private void updateTitle(ProgramLocation location) {
        if (!this.isVisible()) {
            return;
        }
        Function function = this.getFunction(location);
        if (function == null) {
            this.setSubTitle("NOT A FUNCTION");
        } else {
            this.setSubTitle("");
        }
    }

    private JPanel createWorkPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(this.createInputPanel());
        this.mainPanel.add((Component)bottomPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(this.MIN_WIDTH, this.MIN_HEIGHT));
        this.sourcePanel = new SourceTagsPanel(this, this.tool, "All Tags");
        this.targetPanel = new TargetTagsPanel(this, this.tool, "Assigned To Function");
        this.allFunctionsPanel = new AllFunctionsPanel(this.program, this, "Functions with Selected Tag");
        this.buttonPanel = new FunctionTagButtonPanel(this.sourcePanel, this.targetPanel);
        this.sourcePanel.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        this.targetPanel.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        this.allFunctionsPanel.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER));
        this.targetPanel.setMinimumSize(new Dimension(0, 0));
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 0));
        wrapper.add(this.sourcePanel);
        wrapper.add(this.buttonPanel);
        wrapper.add(this.targetPanel);
        JSplitPane splitter = new JSplitPane(1, wrapper, this.allFunctionsPanel);
        this.mainPanel.add((Component)splitter, "Center");
        splitter.setResizeWeight(0.5);
        splitter.setDividerLocation(0.5);
        return this.mainPanel;
    }

    public void selectionChanged(TagListPanel panel) {
        Function function = this.getFunction(this.currentLocation);
        if (panel instanceof SourceTagsPanel) {
            this.buttonPanel.sourcePanelSelectionChanged(function != null);
            this.targetPanel.clearSelection();
        } else if (panel instanceof TargetTagsPanel) {
            this.buttonPanel.targetPanelSelectionChanged(function != null);
            this.sourcePanel.clearSelection();
        }
        Set<FunctionTag> sourceTags = this.sourcePanel.getSelectedTags();
        Set<FunctionTag> targetTags = this.targetPanel.getSelectedTags();
        sourceTags.addAll(targetTags);
        this.allFunctionsPanel.setSelectedTags(sourceTags);
    }

    public AllFunctionsPanel getAllFunctionsPanel() {
        return this.allFunctionsPanel;
    }

    public TargetTagsPanel getTargetPanel() {
        return this.targetPanel;
    }

    public HintTextField getTagInputField() {
        return this.tagInputField;
    }

    public SourceTagsPanel getSourcePanel() {
        return this.sourcePanel;
    }

    public FunctionTagButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JPanel getInputPanel() {
        return this.inputPanel;
    }

    void pressEnterOnTagInputField() {
        this.processCreates();
    }

    Set<FunctionTag> backgroundLoadTags() {
        List<? extends FunctionTag> dbTags = this.getAllTagsFromDatabase();
        HashSet<FunctionTag> allTags = new HashSet<FunctionTag>(dbTags);
        allTags.addAll(this.getFileTags());
        return allTags;
    }

    private Set<FunctionTag> getFileTags() {
        if (this.tagsFromFile == null) {
            this.tagsFromFile = FunctionTagLoader.loadTags(TAG_FILE);
        }
        return this.tagsFromFile;
    }

    private List<? extends FunctionTag> getAllTagsFromDatabase() {
        if (this.program == null) {
            return Collections.emptyList();
        }
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)this.program.getFunctionManager();
        return functionManagerDB.getFunctionTagManager().getAllFunctionTags();
    }

    private Function getFunction(ProgramLocation loc) {
        Address functionAddress = this.getFunctionAddress(loc);
        if (functionAddress == null) {
            return null;
        }
        return this.program.getFunctionManager().getFunctionContaining(functionAddress);
    }

    private Address getFunctionAddress(ProgramLocation loc) {
        if (this.program == null || loc == null) {
            return null;
        }
        if (this.program.getFunctionManager().isInFunction(loc.getAddress())) {
            return loc.getAddress();
        }
        if (loc instanceof FunctionLocation) {
            FunctionLocation functionLocation = (FunctionLocation)loc;
            Address functionAddress = functionLocation.getFunctionAddress();
            return functionAddress;
        }
        return null;
    }

    private void updateTagViews() {
        if (this.mainPanel == null || !this.isVisible()) {
            return;
        }
        this.sourcePanel.setProgram(this.program);
        this.targetPanel.setProgram(this.program);
        this.allFunctionsPanel.setProgram(this.program);
        Set<FunctionTag> sTags = this.sourcePanel.getSelectedTags();
        Set<FunctionTag> tTags = this.targetPanel.getSelectedTags();
        sTags.addAll(tTags);
        if (!sTags.isEmpty()) {
            this.allFunctionsPanel.refresh(sTags);
        }
        Function function = this.getFunction(this.currentLocation);
        this.sourcePanel.refresh(function);
        this.targetPanel.refresh(function);
    }

    private void processCreates() {
        if (this.program == null) {
            Msg.showInfo((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"No Program", (Object)"You must load a program before trying to create tags");
            return;
        }
        ArrayList<String> dropped = new ArrayList<String>();
        List<String> names = this.getInputNames();
        for (String name : names) {
            if (this.sourcePanel.tagExists(name)) {
                dropped.add(name);
                continue;
            }
            CreateFunctionTagCmd cmd = new CreateFunctionTagCmd(name);
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
        if (!dropped.isEmpty()) {
            String text = StringUtils.join(dropped, (String)", ");
            Msg.showInfo((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"Duplicate Tag Names", (Object)("Tags aleady exist.  Ignoring the following tags: " + text));
        }
        Swing.runLater(() -> this.tagInputField.setText(""));
    }

    private List<String> getInputNames() {
        String[] names = this.tagInputField.getText().split(INPUT_DELIMITER);
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : names) {
            if (StringUtils.isBlank((CharSequence)name)) continue;
            nameList.add(name.trim());
        }
        return nameList;
    }

    private JPanel createInputPanel() {
        this.tagInputField = new HintTextField("tag 1, tag 2, ...");
        this.tagInputField.setName("tagInputTF");
        this.tagInputField.addActionListener(e -> this.processCreates());
        this.inputPanel = new JPanel();
        Border outsideBorder = BorderFactory.createBevelBorder(1);
        Border insideBorder = BorderFactory.createEmptyBorder(5, 2, 2, 2);
        this.inputPanel.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 2));
        this.inputPanel.add((Component)new GLabel(" Create new tag(s):"), "West");
        this.inputPanel.add(Box.createHorizontalStrut(5));
        this.inputPanel.add((Component)this.tagInputField, "Center");
        return this.inputPanel;
    }
}

