/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeComparePanel;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncListener;
import ghidra.app.plugin.core.datamgr.DataTypeSyncPanel;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DataTypeSyncDialog
extends DialogComponentProvider
implements DataTypeSyncListener {
    private DataTypeManagerPlugin plugin;
    private JPanel mainPanel;
    private DataTypeSyncPanel syncPanel;
    private DataTypeComparePanel comparePanel;
    private final String operationName;
    private List<DataTypeSyncInfo> selectedInfos = Collections.emptyList();

    public DataTypeSyncDialog(DataTypeManagerPlugin plugin, String clientName, String sourceName, List<DataTypeSyncInfo> list, Set<DataTypeSyncInfo> preselectedInfos, String operationName, String title) {
        super(title, true);
        this.plugin = plugin;
        this.operationName = operationName;
        this.syncPanel = new DataTypeSyncPanel(list, preselectedInfos, this);
        this.comparePanel = new DataTypeComparePanel(clientName, sourceName);
        JSplitPane splitPane = new JSplitPane(0, this.syncPanel, this.comparePanel);
        splitPane.setResizeWeight(0.6);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)splitPane, "Center");
        this.addWorkPanel(this.mainPanel);
        this.initialize();
        this.createActions();
    }

    public void close() {
        super.close();
        this.syncPanel.dispose();
    }

    private void initialize() {
        this.addOKButton();
        this.setOkButtonText(this.operationName);
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), "Commit_Changes_To_Archive"));
    }

    private void createActions() {
        DockingAction selectAllAction = new DockingAction("Select All", "Sync Dialog", false){

            public void actionPerformed(ActionContext context) {
                DataTypeSyncDialog.this.syncPanel.selectAll();
            }
        };
        selectAllAction.setPopupMenuData(new MenuData(new String[]{"Select All"}));
        this.addAction((DockingActionIf)selectAllAction);
        DockingAction deselectAllAction = new DockingAction("Deselect All", "Sync Dialog", false){

            public void actionPerformed(ActionContext context) {
                DataTypeSyncDialog.this.syncPanel.deselectAll();
            }
        };
        deselectAllAction.setPopupMenuData(new MenuData(new String[]{"Deselect All"}));
        this.addAction((DockingActionIf)deselectAllAction);
    }

    @Override
    public void dataTypeSelected(DataTypeSyncInfo syncInfo) {
        if (syncInfo != null) {
            this.comparePanel.setDataTypes(syncInfo.getRefDataType(), syncInfo.getSourceDataType());
        } else {
            this.comparePanel.setDataTypes(null, null);
        }
    }

    protected void okCallback() {
        this.selectedInfos = this.syncPanel.getSelectedInfos();
        this.close();
    }

    protected void cancelCallback() {
        this.close();
    }

    public List<DataTypeSyncInfo> getSelectedInfos() {
        return this.selectedInfos;
    }
}

