/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.options.editor.GenericOptionsComponent;
import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.analysis.AnalysisEnablementTableModel;
import ghidra.app.plugin.core.analysis.AnalysisOptionsUpdater;
import ghidra.app.plugin.core.analysis.AnalyzerEnablementState;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.Analyzer;
import ghidra.framework.Application;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.options.EditorState;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.FileOptions;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

class AnalysisPanel
extends JPanel
implements PropertyChangeListener {
    private static final Options STANDARD_DEFAULT_OPTIONS = new FileOptions("Standard Defaults");
    private static final int CURRENT_PROGRAM_OPTIONS_CHOICE_INDEX = 0;
    private static final int STANDARD_OPTIONS_CHOICE_INDEX = 1;
    private static final String OPTIONS_FILE_EXTENSION = "options";
    public static final String PROTOTYPE = " (Prototype)";
    public static final int COLUMN_ANALYZER_IS_ENABLED = 0;
    static final String ANALYZER_OPTIONS_SAVE_DIR = "analyzer_options";
    public static final String LAST_USED_OPTIONS_CONFIG = "LAST_USED_OPTIONS_CONFIG";
    static final String ANALYZER_OPTIONS_PANEL_NAME = "analyzer.options.panel";
    private List<Program> programs;
    private PropertyChangeListener propertyChangeListener;
    private Options analysisOptions;
    private Options currentProgramOptions;
    private Options selectedOptions = STANDARD_DEFAULT_OPTIONS;
    private GTable table;
    private AnalysisEnablementTableModel model;
    private JTextArea descriptionComponent;
    private JPanel analyzerOptionsPanel;
    private List<EditorState> editorList = new ArrayList<EditorState>();
    private Map<String, Component> analyzerToOptionsPanelMap = new HashMap<String, Component>();
    private Map<String, List<Component>> analyzerManagedComponentsMap = new HashMap<String, List<Component>>();
    private EditorStateFactory editorStateFactory;
    private JPanel noOptionsPanel;
    private GhidraComboBox<Options> optionsComboBox;
    private JButton deleteButton;
    private Options[] optionConfigurationChoices;
    private ItemListener optionsComboBoxListener = this::optionsComboBoxChanged;
    private FileOptions currentNonDefaults;

    AnalysisPanel(Program program, EditorStateFactory editorStateFactory, PropertyChangeListener propertyChangeListener) {
        this(List.of(program), editorStateFactory, propertyChangeListener);
    }

    AnalysisPanel(List<Program> programs, EditorStateFactory editorStateFactory, PropertyChangeListener propertyChangeListener) {
        if (CollectionUtils.isEmpty(programs)) {
            throw new AssertException("Must provide a program to run analysis");
        }
        this.programs = programs;
        this.propertyChangeListener = propertyChangeListener;
        this.editorStateFactory = editorStateFactory;
        this.analysisOptions = programs.get(0).getOptions("Analyzers");
        this.currentProgramOptions = this.getNonDefaultProgramOptions();
        this.setName("Analysis Panel");
        this.build();
        this.replaceOldOptions();
        this.load();
        this.loadCurrentOptionsIntoEditors();
    }

    private Options getNonDefaultProgramOptions() {
        FileOptions options = new FileOptions("Current Program Options");
        List optionNames = this.analysisOptions.getOptionNames();
        for (String optionName : optionNames) {
            if (this.analysisOptions.isDefaultValue(optionName)) continue;
            options.putObject(optionName, this.analysisOptions.getObject(optionName, null));
        }
        return options;
    }

    private void load() {
        this.editorList.clear();
        this.analyzerToOptionsPanelMap.clear();
        this.analyzerManagedComponentsMap.clear();
        int selectedAnalyzerRow = this.table.getSelectedRow();
        this.loadAnalyzers();
        this.loadAnalyzerOptionsPanels();
        if (selectedAnalyzerRow >= 0) {
            this.table.setRowSelectionInterval(selectedAnalyzerRow, selectedAnalyzerRow);
        }
    }

    private void loadAnalyzers() {
        ArrayList<AnalyzerEnablementState> states = new ArrayList<AnalyzerEnablementState>();
        Program program = this.programs.get(0);
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(program);
        List optionNames = this.analysisOptions.getOptionNames();
        Collections.sort(optionNames, (o1, o2) -> o1.compareToIgnoreCase((String)o2));
        for (String analyzerName : optionNames) {
            if (analyzerName.indexOf(46) != -1) continue;
            if (this.analysisOptions.getType(analyzerName) != OptionType.BOOLEAN_TYPE) {
                throw new AssertException("Analyzer 'enable' property that is not boolean - " + analyzerName);
            }
            Analyzer analyzer = manager.getAnalyzer(analyzerName);
            if (analyzer == null) continue;
            boolean enabled = this.analysisOptions.getBoolean(analyzerName, false);
            boolean defaultEnabled = analyzer.getDefaultEnablement(program);
            states.add(new AnalyzerEnablementState(analyzer, enabled, defaultEnabled));
        }
        this.model.setData(states);
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.buildMainPanel(), "Center");
    }

    private JComponent buildMainPanel() {
        this.buildTable();
        this.buildAnalyzerOptionsPanel();
        JSplitPane splitpane = new JSplitPane(1, this.buildLeftPanel(), this.buildRightPanel());
        splitpane.setBorder(null);
        return splitpane;
    }

    private void buildAnalyzerOptionsPanel() {
        this.analyzerOptionsPanel = new JPanel(new BorderLayout());
        this.configureBorder(this.analyzerOptionsPanel, "Options");
    }

    private Component buildOptionsComboBoxPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        this.optionConfigurationChoices = this.loadPossibleOptionsChoicesForComboBox();
        this.optionsComboBox = new GhidraComboBox((Object[])this.optionConfigurationChoices);
        this.selectedOptions = this.currentProgramOptions;
        this.optionsComboBox.setSelectedItem((Object)this.selectedOptions);
        this.optionsComboBox.addItemListener(this.optionsComboBoxListener);
        Dimension preferredSize = this.optionsComboBox.getPreferredSize();
        this.optionsComboBox.setPreferredSize(new Dimension(200, preferredSize.height));
        panel.add((Component)this.optionsComboBox);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(e -> this.deleteSelectedOptionsConfiguration());
        this.deleteButton.setToolTipText("Deletes the currently selected user configuration");
        panel.add(this.deleteButton);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return panel;
    }

    private Component buildRightPanel() {
        JSplitPane splitpane = new JSplitPane(0, this.buildDescriptionPanel(), this.analyzerOptionsPanel);
        splitpane.setBorder(null);
        splitpane.setDividerLocation(0.5);
        return splitpane;
    }

    private JPanel buildDescriptionPanel() {
        this.descriptionComponent = this.buildTextArea();
        JScrollPane descriptionScrollPane = new JScrollPane(this.descriptionComponent);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        this.configureBorder(descriptionScrollPane, "Description");
        descriptionPanel.add((Component)descriptionScrollPane, "Center");
        return descriptionPanel;
    }

    private JTextArea buildTextArea() {
        JTextArea textarea = new JTextArea(3, 20);
        textarea.setEditable(false);
        textarea.setOpaque(false);
        textarea.setWrapStyleWord(true);
        textarea.setLineWrap(true);
        return textarea;
    }

    private JPanel buildLeftPanel() {
        JPanel buttonPanel = this.buildControlPanel();
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(350, 300));
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        this.configureBorder(panel, "Analyzers");
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JPanel buildControlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildButtonPanel(), "North");
        panel.add(this.buildOptionsComboBoxPanel(), "South");
        return panel;
    }

    private JPanel buildButtonPanel() {
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.addActionListener(e -> this.selectAll());
        JButton deselectAllButton = new JButton("Deselect All");
        deselectAllButton.addActionListener(e -> this.deselectAll());
        JButton resetButton = new JButton("Reset");
        resetButton.setToolTipText("Resets the editors to the selected options configuration");
        resetButton.addActionListener(e -> this.loadCurrentOptionsIntoEditors());
        JButton saveButton = new JButton("Save...");
        saveButton.setToolTipText("Saves the current editor settings to a named configuration");
        saveButton.addActionListener(e -> this.saveCurrentOptionsConfiguration());
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(selectAllButton);
        buttonPanel.add(deselectAllButton);
        buttonPanel.add(resetButton);
        buttonPanel.add(saveButton);
        return buttonPanel;
    }

    private void deleteSelectedOptionsConfiguration() {
        if (!this.isUserConfiguration(this.selectedOptions)) {
            return;
        }
        String configurationName = this.selectedOptions.getName();
        int result = OptionDialog.showYesNoDialog((Component)this, (String)"Delete Configuration?", (String)("Are you sure you want to delete options configuration \"" + configurationName + "\"?"));
        if (result != 1) {
            return;
        }
        File configurationFile = this.getOptionsSaveFile(configurationName);
        configurationFile.delete();
        this.selectedOptions = this.currentProgramOptions;
        this.reloadOptionsCombo(this.currentProgramOptions);
        this.loadCurrentOptionsIntoEditors();
    }

    private void selectAll() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.model.setValueAt(true, i, 0);
        }
    }

    private void deselectAll() {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.model.setValueAt(false, i, 0);
        }
    }

    private void saveCurrentOptionsConfiguration() {
        String saveName;
        String defaultSaveName = "";
        if (this.selectedOptions != STANDARD_DEFAULT_OPTIONS && this.selectedOptions != this.currentProgramOptions) {
            defaultSaveName = this.selectedOptions.getName();
        }
        if ((saveName = OptionDialog.showEditableInputChoiceDialog((Component)this, (String)"Save Configuration", (String)"Options Configuration Name", (String[])this.getSavedChoices(), (String)defaultSaveName, (int)3)) == null) {
            return;
        }
        if ((saveName = saveName.trim()).length() == 0) {
            return;
        }
        File saveFile = this.getOptionsSaveFile(saveName);
        if (saveFile.exists() && 0 == OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this, (String)"Overwrite Configuration", (String)("Overwrite existing configuration file: " + saveName + " ?"), (String)"Overwrite")) {
            return;
        }
        FileOptions currentOptions = this.getCurrentOptionsAsFileOptions();
        try {
            currentOptions.save(saveFile);
            this.currentNonDefaults = currentOptions;
            this.reloadOptionsCombo((Options)currentOptions);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error saving default options", (Throwable)e);
        }
    }

    private FileOptions getCurrentOptionsAsFileOptions() {
        FileOptions saveTo = new FileOptions("");
        List<AnalyzerEnablementState> analyzerStates = this.model.getModelData();
        for (AnalyzerEnablementState analyzerState : analyzerStates) {
            String analyzerName = analyzerState.getName();
            boolean enabled = analyzerState.isEnabled();
            if (Objects.equals(enabled, this.analysisOptions.getDefaultValue(analyzerName))) continue;
            saveTo.setBoolean(analyzerName, enabled);
        }
        for (EditorState editorState : this.editorList) {
            editorState.applyNonDefaults((Options)saveTo);
        }
        return saveTo;
    }

    private void loadCurrentOptionsIntoEditors() {
        List<AnalyzerEnablementState> analyzerStates = this.model.getModelData();
        for (AnalyzerEnablementState analyzerState : analyzerStates) {
            String analyzerName = analyzerState.getName();
            Object defaultObject = this.analysisOptions.getDefaultValue(analyzerName);
            boolean defaultValue = defaultObject instanceof Boolean ? (Boolean)defaultObject : false;
            boolean newValue = this.selectedOptions.getBoolean(analyzerName, defaultValue);
            analyzerState.setEnabled(newValue);
            this.setAnalyzerEnabled(analyzerName, newValue, false);
            this.model.fireTableRowsUpdated(0, this.model.getRowCount() - 1);
        }
        for (EditorState editorState : this.editorList) {
            editorState.loadFrom(this.selectedOptions);
        }
        this.updateDeleteButton();
        this.currentNonDefaults = this.getCurrentOptionsAsFileOptions();
    }

    private void reloadOptionsCombo(Options newDefaultOptions) {
        this.optionConfigurationChoices = this.loadPossibleOptionsChoicesForComboBox();
        this.optionsComboBox.setModel(new DefaultComboBoxModel<Options>(this.optionConfigurationChoices));
        Options selected = this.findOptionsByName(newDefaultOptions.getName());
        this.optionsComboBox.setSelectedItem((Object)selected);
    }

    private Options findOptionsByName(String name) {
        for (Options fileOptions : this.optionConfigurationChoices) {
            if (!fileOptions.getName().equals(name)) continue;
            return fileOptions;
        }
        return STANDARD_DEFAULT_OPTIONS;
    }

    private void configureEnabledColumnWidth(int width) {
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setWidth(width);
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setResizable(false);
    }

    private void buildTable() {
        this.model = new AnalysisEnablementTableModel(this, Collections.emptyList());
        this.table = new GTable((TableModel)((Object)this.model));
        this.configureEnabledColumnWidth(60);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this::selectedAnalyzerChanged);
    }

    private void selectedAnalyzerChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.analyzerOptionsPanel.removeAll();
        this.descriptionComponent.setText("");
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            String analyzerName = this.model.getModelData().get(selectedRow).getName();
            Component component = this.analyzerToOptionsPanelMap.get(analyzerName);
            if (component == null) {
                component = this.noOptionsPanel;
            }
            this.analyzerOptionsPanel.add(component, "Center");
            this.descriptionComponent.setText(this.analysisOptions.getDescription(analyzerName));
        }
        this.analyzerOptionsPanel.validate();
        this.analyzerOptionsPanel.repaint();
        this.analyzerOptionsPanel.getParent().validate();
        this.descriptionComponent.setCaretPosition(0);
    }

    private void configureBorder(JComponent component, String title) {
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        component.setBorder(compoundBorder);
    }

    void setAnalyzerEnabled(String analyzerName, boolean enabled, boolean fireEvent) {
        List<Component> list = this.analyzerManagedComponentsMap.get(analyzerName);
        if (list != null) {
            for (Component next : list) {
                next.setEnabled(enabled);
            }
        }
        if (fireEvent) {
            this.propertyChange(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean isDifferent = this.hasChangedValues();
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", null, isDifferent));
    }

    public boolean hasChangedValues() {
        List<AnalyzerEnablementState> analyzerStates = this.model.getModelData();
        boolean changes = false;
        for (AnalyzerEnablementState analyzerState : analyzerStates) {
            boolean origEnabled;
            String analyzerName = analyzerState.getName();
            boolean currEnabled = analyzerState.isEnabled();
            if (currEnabled == (origEnabled = this.analysisOptions.getBoolean(analyzerName, false))) continue;
            changes = true;
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, analyzerName, origEnabled, currEnabled));
        }
        if (changes) {
            return true;
        }
        for (EditorState info : this.editorList) {
            if (!info.isValueChanged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyChanges() {
        int id = this.programs.get(0).startTransaction("Setting Analysis Options");
        boolean commit = false;
        try {
            List<AnalyzerEnablementState> analyzerStates = this.model.getModelData();
            for (AnalyzerEnablementState analyzerState : analyzerStates) {
                String analyzerName = analyzerState.getName();
                boolean enabled = analyzerState.isEnabled();
                this.analysisOptions.setBoolean(analyzerName, enabled);
                commit = true;
            }
            for (EditorState info : this.editorList) {
                info.applyValue();
            }
        }
        finally {
            this.programs.get(0).endTransaction(id, commit);
        }
        this.copyOptionsToAllPrograms();
        this.currentProgramOptions = this.getNonDefaultProgramOptions();
        this.reloadOptionsCombo(this.currentProgramOptions);
        if (this.selectedOptions != this.currentProgramOptions) {
            Preferences.setProperty((String)LAST_USED_OPTIONS_CONFIG, (String)this.selectedOptions.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOptionsToAllPrograms() {
        for (int i = 1; i < this.programs.size(); ++i) {
            Program program = this.programs.get(i);
            int id = program.startTransaction("Setting Analysis Options");
            boolean commit = false;
            try {
                this.copyOptionsTo(program);
                commit = true;
                continue;
            }
            finally {
                program.endTransaction(id, commit);
            }
        }
    }

    private void copyOptionsTo(Program program) {
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(program);
        Options destinationOptions = program.getOptions("Analyzers");
        for (String optionName : this.analysisOptions.getOptionNames()) {
            Object optionValue = this.analysisOptions.getObject(optionName, null);
            if (optionValue == null && !destinationOptions.isRegistered(optionName)) {
                Msg.warn((Object)this, (Object)"Unable to copy null option %s to program %s".formatted(optionName, program.getName()));
                continue;
            }
            destinationOptions.putObject(optionName, optionValue);
        }
        aam.initializeOptions(this.analysisOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceOldOptions() {
        for (Program program : this.programs) {
            boolean commit = false;
            int id = program.startTransaction("Replacing old analysis properties");
            try {
                this.doReplaceOldOptions(program);
                commit = true;
            }
            finally {
                program.endTransaction(id, commit);
            }
        }
    }

    private void doReplaceOldOptions(Program program) {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(program);
        Options programAnalysisOptions = program.getOptions("Analyzers");
        List allAnalyzersOptions = programAnalysisOptions.getChildOptions();
        for (Options analyzerOptions : allAnalyzersOptions) {
            AnalysisOptionsUpdater updater;
            String analyzerName = analyzerOptions.getName();
            Analyzer analyzer = manager.getAnalyzer(analyzerName);
            if (analyzer == null || (updater = analyzer.getOptionsUpdater()) == null) continue;
            this.applyOptionUpdater(analyzerOptions, updater);
        }
    }

    private void applyOptionUpdater(Options analyzerOptions, AnalysisOptionsUpdater updater) {
        Set<AnalysisOptionsUpdater.ReplaceableOption> replaceableOptions = updater.getReplaceableOptions();
        for (AnalysisOptionsUpdater.ReplaceableOption ro : replaceableOptions) {
            String newName = ro.getNewName();
            String oldName = ro.getOldName();
            if (!analyzerOptions.contains(oldName)) continue;
            if (!analyzerOptions.contains(newName)) {
                Msg.error((Object)this, (Object)("Found an option replacer without having the new option registerednew option: '" + newName + "'; old option: '" + oldName + "'"));
                continue;
            }
            ro.replace(analyzerOptions);
            analyzerOptions.removeOption(ro.getOldName());
        }
    }

    private void loadAnalyzerOptionsPanels() {
        List optionGroups = this.analysisOptions.getChildOptions();
        this.noOptionsPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        this.noOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.noOptionsPanel.add((Component)new GLabel("No options available."));
        HelpService help = Help.getHelpService();
        for (Options optionsGroup : optionGroups) {
            String analyzerName = optionsGroup.getName();
            JPanel optionsContainer = new JPanel((LayoutManager)new VerticalLayout(5));
            optionsContainer.setName(ANALYZER_OPTIONS_PANEL_NAME);
            optionsContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            JScrollPane scrollPane = new JScrollPane(optionsContainer);
            scrollPane.setBorder(null);
            this.analyzerToOptionsPanelMap.put(analyzerName, scrollPane);
            this.analyzerManagedComponentsMap.put(analyzerName, new ArrayList());
            List<String> optionNames = this.getOptionNames(optionsGroup);
            Collections.sort(optionNames);
            ArrayList<GenericOptionsComponent> optionComponents = new ArrayList<GenericOptionsComponent>();
            for (String childOptionName : optionNames) {
                EditorState childState = this.editorStateFactory.getEditorState(optionsGroup, childOptionName, (PropertyChangeListener)this);
                GenericOptionsComponent comp = GenericOptionsComponent.createOptionComponent((EditorState)childState);
                HelpLocation helpLoc = this.analysisOptions.getHelpLocation(analyzerName + Options.DELIMITER_STRING + childOptionName);
                if (helpLoc != null) {
                    help.registerHelp((Object)comp, helpLoc);
                }
                optionsContainer.add((Component)comp);
                optionComponents.add(comp);
                this.analyzerManagedComponentsMap.get(analyzerName).add((Component)comp);
                this.editorList.add(childState);
            }
            GenericOptionsComponent.alignLabels(optionComponents);
            Object value = this.analysisOptions.getObject(analyzerName, null);
            boolean enabled = true;
            if (value instanceof Boolean) {
                enabled = (Boolean)value;
            }
            this.setAnalyzerEnabled(analyzerName, enabled, false);
        }
    }

    private List<String> getOptionNames(Options optionsGroup) {
        List subOptions = optionsGroup.getLeafOptionNames();
        Iterator it = subOptions.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.isEditable(optionsGroup, name)) {
                it.remove();
            }
            if (optionsGroup.isRegistered(name)) continue;
            it.remove();
        }
        return subOptions;
    }

    private boolean isEditable(Options options, String optionName) {
        PropertyEditor editor = options.getPropertyEditor(optionName);
        return options.getObject(optionName, null) != null || editor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptionForAllPrograms(String analyzerName, boolean enabled) {
        for (Program program : this.programs) {
            Options options = program.getOptions("Analyzers");
            if (!options.getOptionNames().contains(analyzerName)) continue;
            boolean commit = false;
            int id = program.startTransaction("Setting analysis property " + analyzerName);
            try {
                options.setBoolean(analyzerName, enabled);
                commit = true;
            }
            finally {
                program.endTransaction(id, commit);
            }
        }
    }

    private boolean isAnalyzed() {
        Options options = this.programs.get(0).getOptions("Program Information");
        return options.getBoolean("Analyzed", false);
    }

    private Options[] loadPossibleOptionsChoicesForComboBox() {
        List<Options> savedDefaultsList = this.getSavedOptionsObjects();
        FileOptions[] optionsArray = new FileOptions[savedDefaultsList.size() + 2];
        optionsArray[0] = this.currentProgramOptions;
        optionsArray[1] = STANDARD_DEFAULT_OPTIONS;
        for (int i = 0; i < savedDefaultsList.size(); ++i) {
            optionsArray[i + 2] = savedDefaultsList.get(i);
        }
        return optionsArray;
    }

    private String[] getSavedChoices() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 2; i < this.optionConfigurationChoices.length; ++i) {
            list.add(this.optionConfigurationChoices[i].getName());
        }
        String[] a = new String[list.size()];
        list.toArray(a);
        return a;
    }

    private File getOptionsSaveFile(String saveName) {
        File userSettingsDirectory = Application.getUserSettingsDirectory();
        File optionsDir = new File(userSettingsDirectory, ANALYZER_OPTIONS_SAVE_DIR);
        FileUtilities.mkdirs((File)optionsDir);
        return new File(optionsDir, saveName + ".options");
    }

    private List<Options> getSavedOptionsObjects() {
        File userSettingsDirectory = Application.getUserSettingsDirectory();
        File optionsDir = new File(userSettingsDirectory, ANALYZER_OPTIONS_SAVE_DIR);
        if (!optionsDir.isDirectory()) {
            this.migrateOptionsFromPreviousRevision(optionsDir);
        }
        return this.readSavedOptions(optionsDir);
    }

    private List<Options> readSavedOptions(File optionsDir) {
        ArrayList<Options> list = new ArrayList<Options>();
        Object[] listFiles = optionsDir.listFiles();
        Arrays.sort(listFiles);
        for (Object file : listFiles) {
            if (!OPTIONS_FILE_EXTENSION.equals(FilenameUtils.getExtension((String)((File)file).getName()))) continue;
            try {
                FileOptions fileOptions = new FileOptions((File)file);
                list.add((Options)fileOptions);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error reading saved analysis options", (Throwable)e);
            }
        }
        return list;
    }

    private void migrateOptionsFromPreviousRevision(File optionsDir) {
        FileUtilities.mkdirs((File)optionsDir);
        File previous = this.getMostRecentApplicationSettingsDirWithSavedOptions();
        if (previous == null) {
            return;
        }
        List<Options> readSavedOptions = this.readSavedOptions(previous);
        for (Options options : readSavedOptions) {
            FileOptions fileOptions = (FileOptions)options;
            String name = fileOptions.getName();
            try {
                fileOptions.save(this.getOptionsSaveFile(name));
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Error copying analysis options from previous Ghidra install", (Throwable)e);
            }
        }
    }

    private File getMostRecentApplicationSettingsDirWithSavedOptions() {
        List ghidraUserDirsByTime = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        if (ghidraUserDirsByTime.size() == 0) {
            return null;
        }
        for (File ghidraUserDir : ghidraUserDirsByTime) {
            File possible = new File(ghidraUserDir, ANALYZER_OPTIONS_SAVE_DIR);
            if (!possible.exists()) continue;
            return possible;
        }
        return null;
    }

    private boolean isUserConfiguration(Options options) {
        return options != STANDARD_DEFAULT_OPTIONS && options != this.currentProgramOptions;
    }

    private void optionsComboBoxChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (!this.checkOkToChange()) {
                this.optionsComboBox.removeItemListener(this.optionsComboBoxListener);
                this.optionsComboBox.setSelectedItem((Object)this.selectedOptions);
                this.optionsComboBox.addItemListener(this.optionsComboBoxListener);
                return;
            }
            this.selectedOptions = (FileOptions)this.optionsComboBox.getSelectedItem();
            this.updateDeleteButton();
            this.loadCurrentOptionsIntoEditors();
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", null, this.hasChangedValues()));
        }
    }

    private boolean checkOkToChange() {
        FileOptions current = this.getCurrentOptionsAsFileOptions();
        if (Options.hasSameOptionsAndValues((Options)current, (Options)this.currentNonDefaults)) {
            return true;
        }
        int result = OptionDialog.showYesNoDialog((Component)this, (String)"Loose Changes?", (String)"You have made changes from the current options set. If you change\nthe current option set, those changes will be lost.\nDo you want to proceed?");
        return result == 1;
    }

    private void updateDeleteButton() {
        this.deleteButton.setEnabled(this.isUserConfiguration(this.selectedOptions));
    }

    public void setToLastUsedAnalysisOptionsIfProgramNotAnalyzed() {
        if (this.isAnalyzed()) {
            return;
        }
        if (!this.getNonDefaultProgramOptions().getOptionNames().isEmpty()) {
            return;
        }
        String optionsName = Preferences.getProperty((String)LAST_USED_OPTIONS_CONFIG, (String)STANDARD_DEFAULT_OPTIONS.getName());
        Options lastUsed = this.findOptionsByName(optionsName);
        if (lastUsed != null) {
            this.optionsComboBox.setSelectedItem((Object)lastUsed);
        }
    }
}

