/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaKernelModule;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class FridaListKernelModulesCommand
extends AbstractFridaCommand<Void> {
    private List<FridaKernelModule> modules = new ArrayList<FridaKernelModule>();

    public FridaListKernelModulesCommand(FridaManagerImpl manager) {
        super(manager);
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_modules", "result = Kernel.enumerateModules();");
        for (FridaKernelModule module : this.modules) {
            this.manager.addKernelModuleIfAbsent(module);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaKernelModule module = new FridaKernelModule();
        JsonObject modDetails = element.getAsJsonObject();
        module.setName(modDetails.get("name").getAsString());
        module.setRangeAddress(modDetails.get("base").getAsString());
        module.setRangeSize(modDetails.get("size").getAsLong());
        this.modules.add(module);
    }
}

