/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.Sequence;
import ghidra.trace.model.time.schedule.SkipStep;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TickStep;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TraceSchedule
implements Comparable<TraceSchedule> {
    public static final TraceSchedule ZERO = TraceSchedule.snap(0L);
    private static final String PARSE_ERR_MSG = "Time specification must have form 'snap[:steps[.pSteps]]'";
    private final long snap;
    private final Sequence steps;
    private final Sequence pSteps;

    public static final TraceSchedule snap(long snap) {
        return new TraceSchedule(snap, new Sequence(), new Sequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TraceSchedule parse(String spec) {
        Sequence pTicks;
        Sequence ticks;
        long snap;
        String[] parts = spec.split(":", 2);
        if (parts.length > 2) {
            throw new AssertionError();
        }
        try {
            snap = Long.decode(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(PARSE_ERR_MSG, e);
        }
        if (parts.length > 1) {
            String[] subs = parts[1].split("\\.");
            try {
                ticks = Sequence.parse(subs[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(PARSE_ERR_MSG, e);
            }
            if (subs.length == 1) {
                pTicks = new Sequence();
                return new TraceSchedule(snap, ticks, pTicks);
            } else {
                if (subs.length != 2) throw new IllegalArgumentException(PARSE_ERR_MSG);
                try {
                    pTicks = Sequence.parse(subs[1]);
                    return new TraceSchedule(snap, ticks, pTicks);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(PARSE_ERR_MSG, e);
                }
            }
        }
        ticks = new Sequence();
        pTicks = new Sequence();
        return new TraceSchedule(snap, ticks, pTicks);
    }

    public TraceSchedule(long snap, Sequence steps, Sequence pSteps) {
        this.snap = snap;
        this.steps = steps;
        this.pSteps = pSteps;
    }

    public String toString() {
        if (this.pSteps.isNop()) {
            if (this.steps.isNop()) {
                return Long.toString(this.snap);
            }
            return String.format("%d:%s", this.snap, this.steps);
        }
        return String.format("%d:%s.%s", this.snap, this.steps, this.pSteps);
    }

    public CompareResult compareSchedule(TraceSchedule that) {
        CompareResult result = CompareResult.unrelated(Long.compare(this.snap, that.snap));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        result = this.steps.compareSeq(that.steps);
        switch (result) {
            case UNREL_LT: 
            case UNREL_GT: {
                return result;
            }
            case REL_LT: {
                if (this.pSteps.isNop()) {
                    return CompareResult.REL_LT;
                }
                return CompareResult.UNREL_LT;
            }
            case REL_GT: {
                if (that.pSteps.isNop()) {
                    return CompareResult.REL_GT;
                }
                return CompareResult.UNREL_GT;
            }
        }
        result = this.pSteps.compareSeq(that.pSteps);
        if (result != CompareResult.EQUALS) {
            return result;
        }
        return CompareResult.EQUALS;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraceSchedule)) {
            return false;
        }
        TraceSchedule that = (TraceSchedule)obj;
        if (this.snap != that.snap) {
            return false;
        }
        if (!Objects.equals(this.steps, that.steps)) {
            return false;
        }
        return Objects.equals(this.pSteps, that.pSteps);
    }

    public int hashCode() {
        return Objects.hash(this.snap, this.steps, this.pSteps);
    }

    @Override
    public int compareTo(TraceSchedule o) {
        return this.compareSchedule((TraceSchedule)o).compareTo;
    }

    public boolean isSnapOnly() {
        return this.steps.isNop() && this.pSteps.isNop();
    }

    public long getSnap() {
        return this.snap;
    }

    public long getLastThreadKey() {
        long last = this.pSteps.getLastThreadKey();
        if (last != -1L) {
            return last;
        }
        return this.steps.getLastThreadKey();
    }

    public TraceThread getEventThread(Trace trace) {
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(this.snap, false);
        return snapshot == null ? null : snapshot.getEventThread();
    }

    public TraceThread getLastThread(Trace trace) {
        long lastKey = this.getLastThreadKey();
        if (lastKey == -1L) {
            return this.getEventThread(trace);
        }
        return trace.getThreadManager().getThread(lastKey);
    }

    public long totalTickCount() {
        return this.steps.totalTickCount() + this.pSteps.totalTickCount();
    }

    public long totalPatchCount() {
        return this.steps.totalPatchCount() + this.pSteps.totalPatchCount();
    }

    public long tickCount() {
        return this.steps.totalTickCount();
    }

    public long patchCount() {
        return this.steps.totalPatchCount();
    }

    public long pTickCount() {
        return this.pSteps.totalTickCount();
    }

    public long pPatchCount() {
        return this.pSteps.totalPatchCount();
    }

    public void execute(Trace trace, PcodeMachine<?> machine, TaskMonitor monitor) throws CancelledException {
        machine.setSoftwareInterruptMode(PcodeMachine.SwiMode.IGNORE_ALL);
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.execute(trace, lastThread, machine, Stepper.instruction(), monitor);
        lastThread = this.pSteps.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
    }

    public void validate(Trace trace) {
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.validate(trace, lastThread);
        lastThread = this.pSteps.validate(trace, lastThread);
    }

    public void finish(Trace trace, TraceSchedule position, PcodeMachine<?> machine, TaskMonitor monitor) throws CancelledException {
        TraceThread lastThread = position.getLastThread(trace);
        Sequence remains = this.steps.relativize(position.steps);
        machine.setSoftwareInterruptMode(PcodeMachine.SwiMode.IGNORE_ALL);
        if (remains.isNop()) {
            Sequence pRemains = this.pSteps.relativize(position.pSteps);
            lastThread = pRemains.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
        } else {
            lastThread = remains.execute(trace, lastThread, machine, Stepper.instruction(), monitor);
            lastThread = this.pSteps.execute(trace, lastThread, machine, Stepper.pcode(), monitor);
        }
    }

    public TraceSchedule steppedForward(TraceThread thread, long tickCount) {
        Sequence steps = this.steps.clone();
        steps.advance(new TickStep(thread == null ? -1L : thread.getKey(), tickCount));
        return new TraceSchedule(this.snap, steps, new Sequence());
    }

    public TraceSchedule skippedForward(TraceThread thread, long tickCount) {
        Sequence steps = this.steps.clone();
        steps.advance(new SkipStep(thread == null ? -1L : thread.getKey(), tickCount));
        return new TraceSchedule(this.snap, steps, new Sequence());
    }

    protected TraceSchedule doSteppedBackward(Trace trace, long tickCount, Set<Long> visited) {
        if (!visited.add(this.snap)) {
            return null;
        }
        long excess = tickCount - this.totalTickCount() - this.totalPatchCount();
        if (excess > 0L) {
            if (trace == null) {
                return null;
            }
            TraceSnapshot source = trace.getTimeManager().getSnapshot(this.snap, false);
            if (source == null) {
                return null;
            }
            TraceSchedule rec = source.getSchedule();
            if (rec == null) {
                return null;
            }
            return rec.doSteppedBackward(trace, excess, visited);
        }
        Sequence steps = this.steps.clone();
        steps.rewind(tickCount);
        return new TraceSchedule(this.snap, steps, new Sequence());
    }

    public TraceSchedule steppedBackward(Trace trace, long stepCount) {
        return this.doSteppedBackward(trace, stepCount, new HashSet<Long>());
    }

    public TraceSchedule steppedPcodeForward(TraceThread thread, int pTickCount) {
        Sequence pTicks = this.pSteps.clone();
        pTicks.advance(new TickStep(thread == null ? -1L : thread.getKey(), pTickCount));
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
    }

    public TraceSchedule skippedPcodeForward(TraceThread thread, int pTickCount) {
        Sequence pTicks = this.pSteps.clone();
        pTicks.advance(new SkipStep(thread == null ? -1L : thread.getKey(), pTickCount));
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
    }

    public TraceSchedule steppedPcodeBackward(int pStepCount) {
        if ((long)pStepCount > this.pSteps.totalTickCount()) {
            return null;
        }
        Sequence pTicks = this.pSteps.clone();
        pTicks.rewind(pStepCount);
        return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
    }

    private long keyOf(TraceThread thread) {
        return thread == null ? -1L : thread.getKey();
    }

    public TraceSchedule patched(TraceThread thread, Language language, String sleigh) {
        if (!this.pSteps.isNop()) {
            Sequence pTicks = this.pSteps.clone();
            pTicks.advance(new PatchStep(thread.getKey(), sleigh));
            pTicks.coalescePatches(language);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
        }
        Sequence ticks = this.steps.clone();
        ticks.advance(new PatchStep(this.keyOf(thread), sleigh));
        ticks.coalescePatches(language);
        return new TraceSchedule(this.snap, ticks, new Sequence());
    }

    public TraceSchedule patched(TraceThread thread, Language language, List<String> sleigh) {
        if (!this.pSteps.isNop()) {
            Sequence pTicks = this.pSteps.clone();
            for (String line : sleigh) {
                pTicks.advance(new PatchStep(thread.getKey(), line));
            }
            pTicks.coalescePatches(language);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
        }
        Sequence ticks = this.steps.clone();
        for (String line : sleigh) {
            ticks.advance(new PatchStep(thread.getKey(), line));
        }
        ticks.coalescePatches(language);
        return new TraceSchedule(this.snap, ticks, new Sequence());
    }

    public TraceSchedule advanced(TraceSchedule next) {
        if (this.pSteps.isNop()) {
            Sequence ticks = this.steps.clone();
            ticks.advance(next.steps);
            return new TraceSchedule(this.snap, ticks, next.pSteps.clone());
        }
        if (next.steps.isNop()) {
            Sequence pTicks = this.steps.clone();
            pTicks.advance(next.pSteps);
            return new TraceSchedule(this.snap, this.steps.clone(), pTicks);
        }
        throw new IllegalArgumentException("Cannot have instructions steps following p-code steps");
    }

    public Set<TraceThread> getThreads(Trace trace) {
        HashSet<TraceThread> result = new HashSet<TraceThread>();
        TraceThread lastThread = this.getEventThread(trace);
        lastThread = this.steps.collectThreads(result, trace, lastThread);
        lastThread = this.pSteps.collectThreads(result, trace, lastThread);
        result.add(lastThread);
        result.remove(null);
        return result;
    }
}

