/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.LockHold;
import ghidra.util.MergeSortingIterator;
import ghidra.util.UnionAddressSetView;
import ghidra.util.UniqIterator;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DBTraceTimeViewport
implements TraceTimeViewport {
    protected final Trace trace;
    protected final List<Lifespan> ordered = new ArrayList<Lifespan>();
    protected final Lifespan.MutableLifeSet spanSet = new Lifespan.DefaultLifeSet();
    protected final ListenerSet<Runnable> changeListeners = new ListenerSet(Runnable.class);
    protected long snap = 0L;

    protected DBTraceTimeViewport(Trace trace) {
        Lifespan zero = Lifespan.at(0L);
        this.spanSet.add(zero);
        this.ordered.add(zero);
        this.trace = trace;
    }

    @Override
    public void addChangeListener(Runnable l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(Runnable l) {
        this.changeListeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAnyUpper(Lifespan range) {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                for (Lifespan intersecting : this.spanSet.intersecting(range)) {
                    if (!range.contains(intersecting.lmax())) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean isCompletelyVisible(AddressRange range, Lifespan lifespan, T object, TraceTimeViewport.Occlusion<T> occlusion) {
        if (range == null) {
            return false;
        }
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                boolean bl;
                for (Lifespan rng : this.ordered) {
                    if (lifespan.contains(rng.lmax())) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (!occlusion.occluded(object, range, rng)) continue;
                    bl = false;
                }
                return bl;
                boolean bl3 = false;
                return bl3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> AddressSet computeVisibleParts(AddressSetView set, Lifespan lifespan, T object, TraceTimeViewport.Occlusion<T> occlusion) {
        try (LockHold hold = this.trace.lockRead();){
            if (!this.containsAnyUpper(lifespan)) {
                AddressSet addressSet = new AddressSet();
                return addressSet;
            }
            AddressSet remains = new AddressSet(set);
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                Iterator<Lifespan> iterator = this.ordered.iterator();
                do {
                    if (!iterator.hasNext()) throw new AssertionError();
                    Lifespan rng = iterator.next();
                    if (lifespan.contains(rng.lmax())) {
                        AddressSet addressSet = remains;
                        return addressSet;
                    }
                    occlusion.remove(object, remains, rng);
                } while (!remains.isEmpty());
                AddressSet addressSet = remains;
                return addressSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLower(long lower) {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                Lifespan range = (Lifespan)this.spanSet.spanContaining(lower);
                if (range == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = range.lmin() == lower;
                return bl;
            }
        }
    }

    protected static boolean addSnapRange(long lower, long upper, Lifespan.MutableLifeSet spanSet, List<Lifespan> ordered) {
        if (spanSet.contains(lower)) {
            return false;
        }
        Lifespan range = Lifespan.span(lower, upper);
        spanSet.add(range);
        ordered.add(range);
        return true;
    }

    protected static TraceSnapshot locateMostRecentFork(TraceTimeManager timeManager, long from) {
        TraceSnapshot prev;
        while (true) {
            if ((prev = timeManager.getMostRecentSnapshot(from)) == null) {
                return null;
            }
            TraceSchedule prevSched = prev.getSchedule();
            long prevKey = prev.getKey();
            if (prevSched == null) {
                if (prevKey == Long.MIN_VALUE) {
                    return null;
                }
                from = prevKey - 1L;
                continue;
            }
            long forkedSnap = prevSched.getSnap();
            if (forkedSnap != prevKey - 1L) break;
            --from;
        }
        return prev;
    }

    protected static void collectForkRanges(TraceTimeManager timeManager, long curSnap, Lifespan.MutableLifeSet spanSet, List<Lifespan> ordered) {
        while (true) {
            TraceSnapshot fork;
            long prevSnap;
            long l = prevSnap = (fork = DBTraceTimeViewport.locateMostRecentFork(timeManager, curSnap)) == null ? Long.MIN_VALUE : fork.getKey();
            if (!DBTraceTimeViewport.addSnapRange(prevSnap, curSnap, spanSet, ordered)) {
                return;
            }
            if (fork == null) {
                return;
            }
            curSnap = fork.getSchedule().getSnap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshSnapRanges() {
        Lifespan.DefaultLifeSet spanSet = new Lifespan.DefaultLifeSet();
        ArrayList<Lifespan> ordered = new ArrayList<Lifespan>();
        try (LockHold hold = this.trace.lockRead();){
            DBTraceTimeViewport.collectForkRanges(this.trace.getTimeManager(), this.snap, spanSet, ordered);
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                this.spanSet.clear();
                this.ordered.clear();
                this.spanSet.addAll(spanSet);
                this.ordered.addAll(ordered);
            }
        }
        assert (!ordered.isEmpty());
        ((Runnable)this.changeListeners.fire).run();
    }

    @Override
    public void setSnap(long snap) {
        if (this.snap == snap) {
            return;
        }
        this.snap = snap;
        this.refreshSnapRanges();
    }

    protected void updateSnapshotAdded(TraceSnapshot snapshot) {
        if (this.checkSnapshotAddedNeedsRefresh(snapshot)) {
            this.refreshSnapRanges();
        }
    }

    protected void updateSnapshotChanged(TraceSnapshot snapshot) {
        if (this.checkSnapshotChangedNeedsRefresh(snapshot)) {
            this.refreshSnapRanges();
        }
    }

    protected void updateSnapshotDeleted(TraceSnapshot snapshot) {
        if (this.checkSnapshotDeletedNeedsRefresh(snapshot)) {
            this.refreshSnapRanges();
        }
    }

    protected boolean checkSnapshotAddedNeedsRefresh(TraceSnapshot snapshot) {
        if (snapshot.getSchedule() == null) {
            return false;
        }
        return this.spanSet.contains(snapshot.getKey());
    }

    protected boolean checkSnapshotChangedNeedsRefresh(TraceSnapshot snapshot) {
        if (this.isLower(snapshot.getKey())) {
            return true;
        }
        return this.spanSet.contains(snapshot.getKey()) && snapshot.getSchedule() != null;
    }

    protected boolean checkSnapshotDeletedNeedsRefresh(TraceSnapshot snapshot) {
        return this.isLower(snapshot.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isForked() {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                boolean bl = this.ordered.size() > 1;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Lifespan> getOrderedSpans() {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                List<Lifespan> list2 = List.copyOf(this.ordered);
                return list2;
            }
        }
    }

    public List<Lifespan> getOrderedSpans(long snap) {
        try (LockHold hold = this.trace.lockRead();){
            this.setSnap(snap);
            List<Lifespan> list = this.getOrderedSpans();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getOrderedSnaps() {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                List<Long> list2 = this.ordered.stream().map(Lifespan::lmax).collect(Collectors.toList());
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getReversedSnaps() {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                List<Long> reversed = this.ordered.stream().map(Lifespan::lmax).collect(Collectors.toList());
                Collections.reverse(reversed);
                List<Long> list2 = reversed;
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getTop(Function<Long, T> func) {
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                T t;
                for (Lifespan rng : this.ordered) {
                    T t2 = func.apply(rng.lmax());
                    if (t2 == null) continue;
                    t = t2;
                }
                return t;
                Iterator<Lifespan> iterator = null;
                return (T)iterator;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Iterator<T> mergedIterator(Function<Long, Iterator<T>> iterFunc, Comparator<? super T> comparator) {
        List iters;
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                block11: {
                    if (this.isForked()) break block11;
                    Iterator<T> iterator = iterFunc.apply(this.snap);
                    return iterator;
                }
                iters = this.ordered.stream().map(rng -> (Iterator)iterFunc.apply(rng.lmax())).collect(Collectors.toList());
            }
        }
        return new UniqIterator((Iterator)new MergeSortingIterator(iters, comparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetView unionedAddresses(Function<Long, AddressSetView> viewFunc) {
        List views;
        try (LockHold hold = this.trace.lockRead();){
            List<Lifespan> list = this.ordered;
            synchronized (list) {
                block11: {
                    if (this.isForked()) break block11;
                    AddressSetView addressSetView = viewFunc.apply(this.snap);
                    return addressSetView;
                }
                views = this.ordered.stream().map(rng -> (AddressSetView)viewFunc.apply(rng.lmax())).collect(Collectors.toList());
            }
        }
        return new UnionAddressSetView(views);
    }
}

