/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerRegistersAccess;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;

public class DefaultPcodeDebuggerRegistersAccess
extends DefaultPcodeTraceRegistersAccess
implements PcodeDebuggerRegistersAccess,
InternalPcodeDebuggerDataAccess {
    protected final PluginTool tool;
    protected final TraceRecorder recorder;

    protected DefaultPcodeDebuggerRegistersAccess(PluginTool tool, TraceRecorder recorder, TracePlatform platform, long snap, TraceThread thread, int frame, TraceTimeViewport viewport) {
        super(platform, snap, thread, frame, viewport);
        this.tool = tool;
        this.recorder = recorder;
    }

    @Override
    public boolean isLive() {
        return InternalPcodeDebuggerDataAccess.super.isLive();
    }

    @Override
    public PluginTool getTool() {
        return this.tool;
    }

    @Override
    public TraceRecorder getRecorder() {
        return this.recorder;
    }

    @Override
    public CompletableFuture<Boolean> readFromTargetRegisters(AddressSetView guestView) {
        if (guestView.isEmpty() || !this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        HashSet<Register> toRead = new HashSet<Register>();
        Language language = this.platform.getLanguage();
        for (AddressRange guestRng : guestView) {
            Register register = language.getRegister(guestRng.getMinAddress().getPhysicalAddress(), (int)guestRng.getLength());
            if (register == null) {
                Msg.error((Object)this, (Object)("Could not figure register for " + guestRng));
                continue;
            }
            if (!this.recorder.getRegisterMapper(this.thread).getRegistersOnTarget().contains(register)) {
                Msg.warn((Object)this, (Object)("Register not recognized by target: " + register));
                continue;
            }
            toRead.add(register);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.captureThreadRegisters(this.platform, this.thread, 0, toRead).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }

    @Override
    public CompletableFuture<Boolean> writeTargetRegister(Address address, byte[] data) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.writeRegister(this.platform, this.thread, this.frame, address.getPhysicalAddress(), data).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }
}

