/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation.data;

import ghidra.app.plugin.core.debug.service.emulation.data.DefaultPcodeDebuggerPropertyAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.InternalPcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerMemoryAccess;
import ghidra.app.plugin.core.debug.utils.AbstractMappedMemoryBytesVisitor;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultPcodeDebuggerMemoryAccess
extends DefaultPcodeTraceMemoryAccess
implements PcodeDebuggerMemoryAccess,
InternalPcodeDebuggerDataAccess {
    protected final PluginTool tool;
    protected final TraceRecorder recorder;

    protected DefaultPcodeDebuggerMemoryAccess(PluginTool tool, TraceRecorder recorder, TracePlatform platform, long snap, TraceTimeViewport viewport) {
        super(platform, snap, viewport);
        this.tool = Objects.requireNonNull(tool);
        this.recorder = recorder;
    }

    @Override
    public boolean isLive() {
        return InternalPcodeDebuggerDataAccess.super.isLive();
    }

    @Override
    public PluginTool getTool() {
        return this.tool;
    }

    @Override
    public TraceRecorder getRecorder() {
        return this.recorder;
    }

    @Override
    public CompletableFuture<Boolean> readFromTargetMemory(AddressSetView guestView) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        AddressSetView hostView = this.platform.mapGuestToHost(guestView);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.readMemoryBlocks(hostView, TaskMonitor.DUMMY).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }

    @Override
    public CompletableFuture<Boolean> writeTargetMemory(Address address, byte[] data) {
        if (!this.isLive()) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.writeMemory(address, data).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.platform.getTrace().flushEvents())).thenApply(__ -> true);
    }

    @Override
    public boolean readFromStaticImages(final SemisparseByteArray bytes, AddressSetView guestView) {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return false;
        }
        try {
            return new AbstractMappedMemoryBytesVisitor(mappingService, new byte[4096]){

                @Override
                protected int read(Memory memory, Address addr, byte[] dest, int size) throws MemoryAccessException {
                    int read = super.read(memory, addr, dest, size);
                    if (read < size) {
                        Msg.warn((Object)this, (Object)String.format("  Partial read of %s. Wanted %d bytes. Got %d.", addr, size, read));
                    }
                    return read;
                }

                @Override
                protected boolean visitRange(Program program, AddressRange progRng, DebuggerStaticMappingService.MappedAddressRange mappedRng) throws MemoryAccessException {
                    Msg.debug((Object)this, (Object)("Filling in unknown trace memory in emulator using mapped image: " + program + ": " + progRng));
                    return super.visitRange(program, progRng, mappedRng);
                }

                @Override
                protected void visitData(Address hostAddr, byte[] data, int size) {
                    Address guestAddr = DefaultPcodeDebuggerMemoryAccess.this.platform.mapHostToGuest(hostAddr);
                    bytes.putData(guestAddr.getOffset(), data, 0, size);
                }
            }.visit(this.platform.getTrace(), this.snap, this.platform.mapGuestToHost(guestView));
        }
        catch (MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        return new DefaultPcodeDebuggerPropertyAccess<T>(this, name, type);
    }
}

