/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import generic.ULongSpan;
import ghidra.app.plugin.core.debug.service.emulation.AbstractRWTargetPcodeExecutorStatePiece;
import ghidra.app.plugin.core.debug.service.emulation.Mode;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerDataAccess;
import ghidra.app.plugin.core.debug.service.emulation.data.PcodeDebuggerRegistersAccess;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.BytesTracePcodeExecutorStatePiece;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.util.Map;

public class RWTargetRegistersPcodeExecutorStatePiece
extends AbstractRWTargetPcodeExecutorStatePiece {
    private final Mode mode;

    public RWTargetRegistersPcodeExecutorStatePiece(PcodeDebuggerRegistersAccess data, Mode mode) {
        super(data);
        this.mode = mode;
    }

    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> newSpaceMap() {
        return new WRTargetRegistersSpaceMap();
    }

    class WRTargetRegistersSpaceMap
    extends AbstractRWTargetPcodeExecutorStatePiece.TargetBackedSpaceMap {
        public WRTargetRegistersSpaceMap() {
        }

        protected WRTargetRegistersSpaceMap(Map<AddressSpace, BytesTracePcodeExecutorStatePiece.CachedSpace> spaceMap) {
            super(spaceMap);
        }

        public AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<BytesTracePcodeExecutorStatePiece.CachedSpace> fork() {
            return new WRTargetRegistersSpaceMap((Map<AddressSpace, BytesTracePcodeExecutorStatePiece.CachedSpace>)this.fork(this.spaces));
        }

        protected BytesTracePcodeExecutorStatePiece.CachedSpace newSpace(AddressSpace space, PcodeDebuggerDataAccess data) {
            return new RWTargetRegistersCachedSpace(RWTargetRegistersPcodeExecutorStatePiece.this.language, space, (PcodeDebuggerRegistersAccess)data);
        }
    }

    protected class RWTargetRegistersCachedSpace
    extends AbstractRWTargetPcodeExecutorStatePiece.AbstractRWTargetCachedSpace {
        protected final PcodeDebuggerRegistersAccess backing;

        public RWTargetRegistersCachedSpace(Language language, AddressSpace space, PcodeDebuggerRegistersAccess backing) {
            super(language, space, backing);
            this.backing = backing;
        }

        protected RWTargetRegistersCachedSpace(Language language, AddressSpace space, PcodeDebuggerRegistersAccess backing, SemisparseByteArray bytes, AddressSet written) {
            super(language, space, backing, bytes, written);
            this.backing = backing;
        }

        public RWTargetRegistersCachedSpace fork() {
            return new RWTargetRegistersCachedSpace(this.language, RWTargetRegistersPcodeExecutorStatePiece.this.uniqueSpace, this.backing, this.bytes.fork(), new AddressSet((AddressSetView)this.written));
        }

        @Override
        protected ULongSpan.ULongSpanSet readUninitializedFromTarget(ULongSpan.ULongSpanSet uninitialized) {
            if (this.space.isUniqueSpace() || !this.backing.isLive()) {
                return uninitialized;
            }
            AddressSet addrsUninit = this.addrSet(uninitialized);
            AddressSetView unknown = this.backing.intersectUnknown((AddressSetView)addrsUninit);
            this.waitTimeout(this.backing.readFromTargetRegisters(unknown));
            return uninitialized;
        }

        public void write(long offset, byte[] val, int srcOffset, int length) {
            if (RWTargetRegistersPcodeExecutorStatePiece.this.mode.isWriteTarget() && !this.space.isUniqueSpace() && this.waitTimeout(this.backing.writeTargetRegister(this.space.getAddress(offset), val)).booleanValue()) {
                return;
            }
            super.write(offset, val, srcOffset, length);
        }
    }
}

