/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.arm;

import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInjectInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.math.BigInteger;

@DisassemblyInjectInfo(langIDs={"ARM:LE:32:v8", "ARM:LE:32:v8T", "ARM:LEBE:32:v8LEInstruction", "ARM:BE:32:v8", "ARM:BE:32:v8T", "ARM:LE:32:v7", "ARM:LEBE:32:v7LEInstruction", "ARM:BE:32:v7", "ARM:LE:32:Cortex", "ARM:BE:32:Cortex", "ARM:LE:32:v6", "ARM:BE:32:v6", "ARM:LE:32:v5t", "ARM:BE:32:v5t", "ARM:LE:32:v5", "ARM:BE:32:v5", "ARM:LE:32:v4t", "ARM:BE:32:v4t", "ARM:LE:32:v4", "ARM:BE:32:v4"})
public class ArmDisassemblyInject
implements DisassemblyInject {
    protected static final long THUMB_BIT = 32L;

    protected boolean isThumbMode(RegisterValue cpsr) {
        return (cpsr.getUnsignedValue().longValue() & 0x20L) != 0L;
    }

    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, Trace trace, Language language, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        Register cpsrReg = language.getRegister("cpsr");
        Register tModeReg = language.getRegister("TMode");
        if (cpsrReg == null || tModeReg == null) {
            Msg.error((Object)this, (Object)("No cpsr or TMode register in ARM language?: " + language.getLanguageID()));
            return;
        }
        TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, false);
        if (regs == null || regs.getState(snap, cpsrReg) != TraceMemoryState.KNOWN) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
            return;
        }
        RegisterValue cpsrVal = regs.getValue(snap, cpsrReg);
        if (this.isThumbMode(cpsrVal)) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
        } else {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ZERO));
        }
    }
}

