/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.util.Set;
import java.util.stream.Collectors;

public class OverridesDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected DebuggerMappingOffer offerForLanguageAndCSpec(TargetObject target, Endian endian, LanguageCompilerSpecPair lcsp) {
        try {
            return new OverrideOffer(target, endian == lcsp.getLanguageDescription().getEndian() ? -10 : -20, "Override to " + lcsp, lcsp);
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!includeOverrides) {
            return Set.of();
        }
        Endian endian = DebuggerMappingOpinion.getEndian(env);
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        return langServ.getLanguageCompilerSpecPairs(new LanguageCompilerSpecQuery(null, null, null, null, null)).stream().map(lcsp -> this.offerForLanguageAndCSpec(target, endian, (LanguageCompilerSpecPair)lcsp)).collect(Collectors.toSet());
    }

    protected static class OverrideOffer
    extends DefaultDebuggerMappingOffer {
        public OverrideOffer(TargetObject target, int confidence, String description, LanguageCompilerSpecPair lcsp) {
            super(target, confidence, description, lcsp.languageID, lcsp.compilerSpecID, Set.of());
        }
    }
}

