/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SpecialAddress;
import ghidra.program.model.lang.Language;
import ghidra.util.MathUtilities;

public class DefaultDebuggerMemoryMapper
implements DebuggerMemoryMapper {
    protected final AddressFactory traceAddressFactory;
    protected final AddressFactory targetAddressFactory;

    public DefaultDebuggerMemoryMapper(Language traceLanguage, DebuggerObjectModel targetModel) {
        this.traceAddressFactory = traceLanguage.getAddressFactory();
        this.targetAddressFactory = targetModel.getAddressFactory();
    }

    protected static boolean isInFactory(AddressSpace space, AddressFactory factory) {
        return factory.getAddressSpace(space.getName()) == space;
    }

    protected static boolean isInFactory(Address addr, AddressFactory factory) {
        return DefaultDebuggerMemoryMapper.isInFactory(addr.getAddressSpace(), factory);
    }

    protected static Address toSameNamedSpace(Address addr, AddressFactory factory) {
        if (addr.isRegisterAddress()) {
            throw new IllegalArgumentException("Memory mapper cannot handle register addresses");
        }
        return factory.getAddressSpace(addr.getAddressSpace().getName()).getAddress(addr.getOffset());
    }

    @Override
    public Address traceToTarget(Address traceAddr) {
        assert (DefaultDebuggerMemoryMapper.isInFactory(traceAddr, this.traceAddressFactory));
        return DefaultDebuggerMemoryMapper.toSameNamedSpace(traceAddr, this.targetAddressFactory);
    }

    @Override
    public Address targetToTrace(Address targetAddr) {
        if (targetAddr == SpecialAddress.NO_ADDRESS) {
            return SpecialAddress.NO_ADDRESS;
        }
        assert (DefaultDebuggerMemoryMapper.isInFactory(targetAddr, this.targetAddressFactory));
        return DefaultDebuggerMemoryMapper.toSameNamedSpace(targetAddr, this.traceAddressFactory);
    }

    @Override
    public AddressRange targetToTraceTruncated(AddressRange targetRange) {
        Address targetMin;
        long minTargetOffset;
        AddressSpace traceSpace = this.traceAddressFactory.getAddressSpace(targetRange.getAddressSpace().getName());
        long maxTraceSpaceOffset = traceSpace.getMaxAddress().getOffset();
        if (Long.compareUnsigned(maxTraceSpaceOffset, minTargetOffset = (targetMin = targetRange.getMinAddress()).getOffset()) < 0) {
            return null;
        }
        Address traceMin = traceSpace.getAddress(minTargetOffset);
        Address targetMax = targetRange.getMaxAddress();
        long maxTargetOffset = targetMax.getOffset();
        Address traceMax = traceSpace.getAddress(MathUtilities.unsignedMin((long)maxTraceSpaceOffset, (long)maxTargetOffset));
        return new AddressRangeImpl(traceMin, traceMax);
    }
}

