/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.core.assembler.AssemblyDualTextField;
import ghidra.app.plugin.core.assembler.PatchInstructionAction;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;

public abstract class AbstractTracePatchInstructionAction
extends PatchInstructionAction {
    protected final DebuggerDisassemblerPlugin plugin;

    public AbstractTracePatchInstructionAction(DebuggerDisassemblerPlugin plugin, String name) {
        super((Plugin)plugin, name);
        this.plugin = plugin;
    }

    protected abstract TracePlatform getPlatform(CodeUnit var1);

    protected RegisterValue getContextValue(CodeUnit cu) {
        return DebuggerDisassemblerPlugin.deriveAlternativeDefaultContext(this.getPlatform(cu).getLanguage(), this.getAlternativeLanguageID(cu), cu.getAddress());
    }

    protected LanguageID getAlternativeLanguageID(CodeUnit cu) {
        return this.getPlatform(cu).getLanguage().getLanguageID();
    }

    protected AssemblyDualTextField newAssemblyDualTextField() {
        return new AssemblyDualTextField(){
            AssemblyPatternBlock ctx = null;

            protected AssemblyPatternBlock getContext() {
                return this.ctx;
            }

            public void setAddress(Address address) {
                super.setAddress(address);
                RegisterValue rv = AbstractTracePatchInstructionAction.this.getContextValue(AbstractTracePatchInstructionAction.this.getCodeUnit());
                this.ctx = rv == null ? AssemblyPatternBlock.nop() : AssemblyPatternBlock.fromRegisterValue((RegisterValue)rv).fillMask();
            }
        };
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!super.isAddToPopup(context)) {
            return false;
        }
        CodeUnit cu = this.getCodeUnit(context);
        return this.isApplicableToUnit(cu);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!super.isEnabledForContext(context)) {
            return false;
        }
        CodeUnit cu = this.getCodeUnit(context);
        return this.isApplicableToUnit(cu);
    }

    public void actionPerformed(ActionContext context) {
        try {
            DefaultLanguageService.getLanguageService().getLanguage(this.getAlternativeLanguageID(this.getCodeUnit(context)));
        }
        catch (LanguageNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        super.actionPerformed(context);
    }

    protected Language getLanguage(CodeUnit cu) {
        return this.getPlatform(cu).getLanguage();
    }

    protected Assembler getAssembler(CodeUnit cu) {
        return Assemblers.getAssembler((Language)this.language);
    }

    protected void applyPatch(byte[] data) throws MemoryAccessException {
        TraceProgramView view = this.getView();
        if (view == null) {
            return;
        }
        Address address = this.getAddress();
        CodeUnit cu = this.getCodeUnit();
        RegisterValue contextValue = this.getContextValue(cu);
        TracePlatform platform = this.getPlatform(cu);
        view.getMemory().setBytes(address, data);
        AddressSet set = new AddressSet(address, address.add((long)(data.length - 1)));
        TraceDisassembleCommand dis = new TraceDisassembleCommand(platform, address, (AddressSetView)set);
        if (contextValue != null) {
            dis.setInitialContext(contextValue);
        }
        dis.run(this.tool, (UndoableDomainObject)view);
    }

    protected TraceProgramView getView() {
        Program program = this.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return null;
        }
        return (TraceProgramView)program;
    }
}

