/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbInferiorThreadGroup;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GdbListInferiorsCommand
extends AbstractGdbCommand<Map<Integer, GdbInferior>> {
    public GdbListInferiorsCommand(GdbManagerImpl manager) {
        super(manager);
    }

    @Override
    public String encode() {
        return "-list-thread-groups";
    }

    @Override
    public Map<Integer, GdbInferior> complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        List<GdbInferiorThreadGroup> groups = done.assumeInferiorGroups();
        HashSet<Integer> ids = new HashSet<Integer>();
        Map<Integer, GdbInferiorImpl> allInferiors = this.manager.getKnownInferiorsInternal();
        Set<Integer> curIds = allInferiors.keySet();
        for (GdbInferiorThreadGroup g : groups) {
            ids.add(g.getInferiorId());
            GdbInferiorImpl exists = allInferiors.get(g.getInferiorId());
            if (exists != null) {
                exists.update(g);
                continue;
            }
            Msg.warn((Object)this, (Object)("Resync: Was missing group: i" + g));
            this.manager.addInferior(new GdbInferiorImpl(this.manager, g), GdbCause.Causes.UNCLAIMED);
        }
        Iterator<Object> iterator = new ArrayList<Integer>(curIds).iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (ids.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra group: i" + id));
            this.manager.removeInferior(id, GdbCause.Causes.UNCLAIMED);
        }
        return this.manager.getKnownInferiors();
    }
}

