/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.FolderItem;
import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.Msg;
import ghidra.util.PropertyFile;
import ghidra.util.exception.NotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class IndexedV1LocalFileSystem
extends IndexedLocalFileSystem {
    public static final int INDEX_VERSION = 1;
    private HashMap<String, IndexedLocalFileSystem.Item> fileIdMap;

    protected IndexedV1LocalFileSystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching, boolean create) throws IOException {
        super(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, create);
    }

    private IndexedV1LocalFileSystem(String rootPath) throws IOException {
        super(rootPath);
    }

    @Override
    public int getIndexImplementationVersion() {
        return 1;
    }

    @Override
    String formatIndexItem(IndexedLocalFileSystem.Item item) {
        String entry = item.getStorageName() + ":" + item.getName();
        String fileId = item.getFileID();
        if (fileId != null) {
            entry = entry + ":" + fileId;
        }
        return entry;
    }

    @Override
    IndexedLocalFileSystem.Item parseIndexItem(IndexedLocalFileSystem.Folder parent, String entry) {
        int index = entry.indexOf(":");
        if (index < 0) {
            return null;
        }
        String storageName = entry.substring(0, index);
        String name = entry.substring(index + 1);
        String fileId = null;
        index = name.indexOf(":");
        if (index > 0) {
            fileId = name.substring(index + 1);
            name = name.substring(0, index);
        }
        return new IndexedLocalFileSystem.Item(parent, name, fileId, storageName);
    }

    @Override
    protected synchronized void fileIdChanged(PropertyFile pfile, String oldFileId) throws IOException {
        this.indexJournal.open();
        try {
            IndexedLocalFileSystem.Folder folder = this.getFolder(pfile.getParentPath(), IndexedLocalFileSystem.GetFolderOption.READ_ONLY);
            IndexedLocalFileSystem.Item item = folder.items.get(pfile.getName());
            if (item == null) {
                throw new NotFoundException(pfile.getPath());
            }
            item.setFileID(pfile.getFileID());
            this.indexJournal.fileIdSet(pfile.getPath(), pfile.getFileID());
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        finally {
            this.indexJournal.close();
        }
    }

    private HashMap<String, IndexedLocalFileSystem.Item> getFileIdMap() {
        if (this.fileIdMap == null) {
            this.fileIdMap = new HashMap();
        }
        return this.fileIdMap;
    }

    @Override
    void mapFileID(String fileId, IndexedLocalFileSystem.Item item) {
        this.getFileIdMap().put(fileId, item);
    }

    @Override
    void unmapFileID(String fileId) {
        this.getFileIdMap().remove(fileId);
    }

    @Override
    public FolderItem getItem(String fileID) throws IOException, UnsupportedOperationException {
        this.checkDisposed();
        if (this.fileIdMap == null) {
            return null;
        }
        IndexedLocalFileSystem.Item item = this.fileIdMap.get(fileID);
        if (item == null) {
            return null;
        }
        try {
            PropertyFile propertyFile = item.itemStorage.getPropertyFile();
            if (propertyFile.exists()) {
                return LocalFolderItem.getFolderItem(this, propertyFile);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static IndexedV1LocalFileSystem getFileSystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        try {
            return new IndexedV1LocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, false);
        }
        catch (IndexedLocalFileSystem.IndexReadException e) {
            if (readOnly) {
                throw e;
            }
            Msg.error(LocalFileSystem.class, (Object)("Indexed filesystem error: " + e.getMessage()));
            Msg.info(LocalFileSystem.class, (Object)("Attempting index rebuild: " + rootPath));
            if (!IndexedV1LocalFileSystem.rebuild(new File(rootPath))) {
                throw e;
            }
            return new IndexedV1LocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, false);
        }
    }

    public static boolean rebuild(File rootDir) throws IOException {
        IndexedV1LocalFileSystem.verifyIndexedFileStructure(rootDir);
        IndexedV1LocalFileSystem fs = new IndexedV1LocalFileSystem(rootDir.getAbsolutePath());
        fs.rebuildIndex();
        fs.cleanupAfterConstruction();
        fs.dispose();
        File errorFile = new File(rootDir, "~rebuild.err");
        if (errorFile.exists()) {
            Msg.error(LocalFileSystem.class, (Object)("Indexed filesystem rebuild failed, see log for details: " + errorFile));
            return false;
        }
        Msg.info(LocalFileSystem.class, (Object)("Index rebuild completed: " + rootDir));
        return true;
    }
}

