/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfDirectoryStream700;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFreePageMap700;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStreamTable700;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class Msf700
extends AbstractMsf {
    private static final int PAGE_NUMBER_SIZE = 4;
    private static final byte[] IDENTIFICATION = "Microsoft C/C++ MSF 7.00\r\n\u001aDS".getBytes();
    private static final int IDENTIFICATION_PADDING = 3;
    private static final int PAGE_SIZE_OFFSET = IDENTIFICATION.length + 3;
    static final int NUM_REQUIRED_DETECTION_BYTES_700 = PAGE_SIZE_OFFSET + 4;

    public Msf700(RandomAccessFile file, String filename, TaskMonitor monitor, PdbReaderOptions pdbOptions) throws IOException, PdbException {
        super(file, filename, monitor, pdbOptions);
    }

    @Override
    public void create() {
        this.streamTable = new MsfStreamTable700(this);
        this.freePageMap = new MsfFreePageMap700(this);
        this.directoryStream = new MsfDirectoryStream700(this);
    }

    @Override
    public void parseFreePageMapPageNumber(PdbByteReader reader) throws PdbException {
        this.currentFreePageMapFirstPageNumber = reader.parseInt();
    }

    @Override
    public void parseCurrentNumPages(PdbByteReader reader) throws PdbException {
        this.numPages = reader.parseInt();
    }

    @Override
    public void configureParameters() throws PdbException {
        switch (this.pageSize) {
            case 512: {
                this.log2PageSize = 9;
                this.freePageMapNumSequentialPage = 1;
                break;
            }
            case 1024: {
                this.log2PageSize = 10;
                this.freePageMapNumSequentialPage = 1;
                break;
            }
            case 2048: {
                this.log2PageSize = 11;
                this.freePageMapNumSequentialPage = 1;
                break;
            }
            case 4096: {
                this.log2PageSize = 12;
                this.freePageMapNumSequentialPage = 1;
                break;
            }
            default: {
                throw new PdbException(String.format("Unknown page size: 0X%08X", this.pageSize));
            }
        }
        this.pageSizeModMask = this.pageSize - 1;
    }

    static boolean detected(RandomAccessFile file) throws IOException {
        byte[] bytes = new byte[IDENTIFICATION.length];
        file.seek(0L);
        file.read(bytes, 0, IDENTIFICATION.length);
        return Arrays.equals(bytes, IDENTIFICATION);
    }

    @Override
    public int getPageNumberSize() {
        return 4;
    }

    @Override
    public byte[] getIdentification() {
        return IDENTIFICATION;
    }

    @Override
    public int getPageSizeOffset() {
        return PAGE_SIZE_OFFSET;
    }
}

