/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.KeyEntryListener;
import docking.actions.KeyBindingUtils;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class KeyEntryTextField
extends JTextField {
    private KeyEntryListener listener;
    private String ksName;
    private KeyStroke currentKeyStroke;

    public KeyEntryTextField(int columns, KeyEntryListener listener) {
        super(columns);
        this.listener = listener;
        this.addKeyListener(new MyKeyListener());
    }

    public KeyStroke getKeyStroke() {
        return this.currentKeyStroke;
    }

    public void setKeyStroke(KeyStroke ks) {
        this.processEntry(ks);
        this.setText(KeyEntryTextField.parseKeyStroke(ks));
    }

    public static String parseKeyStroke(KeyStroke ks) {
        return KeyBindingUtils.parseKeyStroke(ks);
    }

    public void clearField() {
        this.ksName = null;
        this.setText("");
        this.currentKeyStroke = null;
    }

    private void processEntry(KeyStroke ks) {
        char keyChar;
        this.ksName = null;
        this.currentKeyStroke = ks;
        if (ks != null && !Character.isWhitespace(keyChar = ks.getKeyChar()) && Character.getType(keyChar) != 15) {
            this.ksName = KeyBindingUtils.parseKeyStroke(ks);
        }
        this.listener.processEntry(ks);
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (KeyEntryTextField.this.ksName != null) {
                KeyEntryTextField.this.setText(KeyEntryTextField.this.ksName);
            } else {
                KeyEntryTextField.this.setText("");
            }
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (this.isHelpKey(keyCode)) {
                return;
            }
            KeyStroke keyStroke = null;
            if (!this.isClearKey(keyCode) && !this.isModifiersOnly(e)) {
                keyStroke = KeyStroke.getKeyStroke(keyCode, e.getModifiersEx());
            }
            KeyEntryTextField.this.processEntry(keyStroke);
            e.consume();
        }

        private boolean isHelpKey(int keyCode) {
            return keyCode == 112 || keyCode == 156;
        }

        private boolean isClearKey(int keyCode) {
            return keyCode == 8 || keyCode == 10;
        }

        private boolean isModifiersOnly(KeyEvent event) {
            String keyText = KeyEvent.getKeyText(event.getKeyCode());
            return keyText.equals(KeyEvent.getKeyText(17)) || keyText.equals(KeyEvent.getKeyText(18)) || keyText.equals(KeyEvent.getKeyText(16)) || keyText.equals(KeyEvent.getKeyText(157));
        }
    }
}

