/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerInterpreterService;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.PluginToolUtils;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.util.concurrent.CompletableFuture;

@DebuggerBotInfo(description="Show debugger interpreters", details="Listens for new debuggers supporting the interpreter interface, and when found, displays that interpeter.", help=@HelpInfo(anchor="show_interpreter"), enabledByDefault=true)
public class ShowInterpreterDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;

    @Override
    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin != null;
    }

    @Override
    public void disable() {
        this.plugin = null;
    }

    @Override
    public void modelAdded(DebuggerObjectModel model) {
        ((CompletableFuture)((CompletableFuture)model.fetchModelRoot().thenCompose(root -> {
            CompletableFuture fi = DebugModelConventions.findSuitable(TargetInterpreter.class, (TargetObject)root);
            return fi;
        })).thenAccept(interpreter -> {
            if (interpreter == null) {
                return;
            }
            DebuggerInterpreterService service = (DebuggerInterpreterService)PluginToolUtils.getServiceFromRunningCompatibleTool((PluginTool)this.plugin.getTool(), DebuggerInterpreterService.class);
            if (service == null) {
                return;
            }
            Swing.runIfSwingOrRunLater(() -> service.showConsole((TargetInterpreter)interpreter));
        })).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Error displaying debugger interpreter for " + model), (Throwable)ex);
            return null;
        });
    }

    @Override
    public void modelRemoved(DebuggerObjectModel model) {
    }
}

