/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.lldb;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.Set;

public class LldbArmDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_AARCH64 = new LanguageID("AARCH64:LE:64:v8A");
    protected static final CompilerSpecID COMP_ID_DEFAULT = new CompilerSpecID("default");

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includesOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        if (!env.getDebugger().toLowerCase().contains("lldb")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        boolean is64Bit = arch.contains("AARCH64") || arch.contains("arm64");
        String os = env.getOperatingSystem();
        if ((os.contains("macos") || os.contains("ios")) && is64Bit) {
            Msg.info((Object)this, (Object)("Using os=" + os + " arch=" + arch));
            return Set.of(new LldbAarch64MacosOffer((TargetProcess)target));
        }
        return Set.of();
    }

    protected static class LldbAarch64MacosOffer
    extends DefaultDebuggerMappingOffer {
        public LldbAarch64MacosOffer(TargetProcess process) {
            super((TargetObject)process, 50, "AARCH64/LLDB on macos", LANG_ID_AARCH64, COMP_ID_DEFAULT, Set.of("cpsr"));
        }
    }

    protected static class LldbI386X86_64RegisterMapper
    extends DefaultDebuggerRegisterMapper {
        public LldbI386X86_64RegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer) {
            super(cSpec, targetRegContainer, false);
        }

        @Override
        protected String normalizeName(String name) {
            if ("rflags".equals(name = super.normalizeName(name))) {
                return "eflags";
            }
            return name;
        }
    }
}

