/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.watch;

import db.Transaction;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesProvider;
import ghidra.app.plugin.core.debug.gui.watch.SavedSettings;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DebuggerControlService;
import ghidra.async.AsyncUtils;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.options.SaveState;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class WatchRow {
    public static final int TRUNCATE_BYTES_LENGTH = 64;
    private static final String KEY_EXPRESSION = "expression";
    private static final String KEY_DATA_TYPE = "dataType";
    private static final String KEY_SETTINGS = "settings";
    private final DebuggerWatchesProvider provider;
    private String expression;
    private String typePath;
    private DataType dataType;
    private SettingsImpl settings = new SettingsImpl();
    private SavedSettings savedSettings = new SavedSettings((Settings)this.settings);
    private PcodeExpression compiled;
    private TraceMemoryState state;
    private Address address;
    private Symbol symbol;
    private AddressSetView reads;
    private byte[] value;
    private byte[] prevValue;
    private String valueString;
    private Object valueObj;
    private Throwable error = null;

    public WatchRow(DebuggerWatchesProvider provider, String expression) {
        this.provider = provider;
        this.expression = expression;
    }

    protected void blank() {
        this.state = null;
        this.address = null;
        this.symbol = null;
        this.reads = null;
        this.value = null;
        this.valueString = null;
        this.valueObj = null;
    }

    protected void recompile() {
        this.compiled = null;
        this.error = null;
        if (this.provider.language == null) {
            return;
        }
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        try {
            this.compiled = DebuggerPcodeUtils.compileExpression(this.provider.getTool(), this.provider.current, this.expression);
        }
        catch (Exception e) {
            this.error = e;
            return;
        }
    }

    protected void reevaluate() {
        this.blank();
        PcodeExecutor<DebuggerPcodeUtils.WatchValue> executor = this.provider.asyncWatchExecutor;
        PcodeExecutor<byte[]> prevExec = this.provider.prevValueExecutor;
        if (executor == null) {
            this.provider.contextChanged();
            return;
        }
        ((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.recompile();
            if (this.compiled == null) {
                this.provider.contextChanged();
                return;
            }
            DebuggerPcodeUtils.WatchValue fullValue = (DebuggerPcodeUtils.WatchValue)this.compiled.evaluate(executor);
            this.prevValue = prevExec == null ? null : (byte[])this.compiled.evaluate(prevExec);
            TracePlatform platform = this.provider.current.getPlatform();
            this.value = fullValue.bytes().bytes();
            this.error = null;
            this.state = fullValue.state();
            this.address = platform.mapGuestToHost(fullValue.address());
            this.symbol = this.computeSymbol();
            this.reads = fullValue.reads();
            this.valueObj = this.parseAsDataTypeObj();
            this.valueString = this.parseAsDataTypeStr();
        }, this.provider.workQueue).exceptionally(e -> {
            this.error = e;
            this.provider.contextChanged();
            return null;
        })).thenRunAsync(() -> {
            this.provider.watchTableModel.fireTableDataChanged();
            this.provider.contextChanged();
        }, AsyncUtils.SWING_EXECUTOR);
    }

    private ByteMemBufferImpl createMemBuffer() {
        return new ByteMemBufferImpl(this.address, this.value, this.provider.language.isBigEndian()){

            public Memory getMemory() {
                return WatchRow.this.provider.current.getTrace().getProgramView().getMemory();
            }
        };
    }

    protected String parseAsDataTypeStr() {
        if (this.dataType == null || this.value == null) {
            return "";
        }
        ByteMemBufferImpl buffer = this.createMemBuffer();
        return this.dataType.getRepresentation((MemBuffer)buffer, (Settings)this.settings, this.value.length);
    }

    protected Object parseAsDataTypeObj() {
        if (this.dataType == null || this.value == null) {
            return null;
        }
        ByteMemBufferImpl buffer = this.createMemBuffer();
        return this.dataType.getValue((MemBuffer)buffer, (Settings)this.settings, this.value.length);
    }

    public void setExpression(String expression) {
        if (!Objects.equals(this.expression, expression)) {
            this.prevValue = null;
        }
        this.expression = expression;
        this.compiled = null;
        this.reevaluate();
    }

    public String getExpression() {
        return this.expression;
    }

    protected void updateType() {
        DataTypeManagerService dtms;
        this.dataType = null;
        if (this.typePath == null) {
            return;
        }
        Trace trace = this.provider.current.getTrace();
        if (trace != null) {
            this.dataType = trace.getDataTypeManager().getDataType(this.typePath);
            if (this.dataType != null) {
                return;
            }
        }
        if ((dtms = (DataTypeManagerService)this.provider.getTool().getService(DataTypeManagerService.class)) != null) {
            this.dataType = dtms.getBuiltInDataTypesManager().getDataType(this.typePath);
        }
    }

    public void setTypePath(String typePath) {
        this.typePath = typePath;
        this.updateType();
    }

    public String getTypePath() {
        return this.typePath;
    }

    public void setDataType(DataType dataType) {
        if (dataType instanceof Pointer) {
            Pointer ptrType = (Pointer)dataType;
            if (this.address != null && this.address.isRegisterAddress()) {
                AddressSpace space = this.provider.current.getTrace().getBaseAddressFactory().getDefaultAddressSpace();
                DataTypeManager dtm = ptrType.getDataTypeManager();
                dataType = new PointerTypedef(null, ptrType.getDataType(), ptrType.getLength(), dtm, space);
                if (dtm != null) {
                    try (Transaction tid = dtm.openTransaction("Resolve data type");){
                        dataType = dtm.resolve(dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
                    }
                }
            }
        }
        this.typePath = dataType == null ? null : dataType.getPathName();
        this.dataType = dataType;
        this.settings.setDefaultSettings(dataType == null ? null : dataType.getDefaultSettings());
        this.valueString = this.parseAsDataTypeStr();
        this.valueObj = this.parseAsDataTypeObj();
        this.provider.contextChanged();
        if (dataType != null) {
            this.savedSettings.read(dataType.getSettingsDefinitions(), dataType.getDefaultSettings());
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected void settingsChanged() {
        if (this.dataType != null) {
            this.savedSettings.write(this.dataType.getSettingsDefinitions(), this.dataType.getDefaultSettings());
        }
        this.valueString = this.parseAsDataTypeStr();
        this.provider.watchTableModel.fireTableDataChanged();
    }

    public Address getAddress() {
        return this.address;
    }

    public AddressRange getRange() {
        if (this.address == null || this.value == null) {
            return null;
        }
        if (this.address.isConstantAddress()) {
            return new AddressRangeImpl(this.address, this.address);
        }
        try {
            return new AddressRangeImpl(this.address, (long)this.value.length);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getRawValueString() {
        if (this.value == null || this.provider.language == null) {
            return "??";
        }
        if (this.address == null || !this.address.getAddressSpace().isMemorySpace()) {
            BigInteger asBigInt = Utils.bytesToBigInteger((byte[])this.value, (int)this.value.length, (boolean)this.provider.language.isBigEndian(), (boolean)false);
            return "0x" + asBigInt.toString(16);
        }
        if (this.value.length > 64) {
            return "{ " + NumericUtilities.convertBytesToString((byte[])this.value, (int)0, (int)64, (String)" ") + " ... }";
        }
        return "{ " + NumericUtilities.convertBytesToString((byte[])this.value, (String)" ") + " }";
    }

    public AddressSetView getReads() {
        return this.reads;
    }

    public TraceMemoryState getState() {
        return this.state;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Object getValueObj() {
        return this.valueObj;
    }

    public boolean isRawValueEditable() {
        if (!this.provider.isEditsEnabled()) {
            return false;
        }
        if (this.address == null) {
            return false;
        }
        DebuggerControlService controlService = this.provider.controlService;
        if (controlService == null) {
            return false;
        }
        DebuggerControlService.StateEditor editor = controlService.createStateEditor(this.provider.current);
        return editor.isVariableEditable(this.address, this.getValueLength());
    }

    public void setRawValueString(String valueString) {
        if ((valueString = valueString.trim()).startsWith("{")) {
            if (!valueString.endsWith("}")) {
                throw new NumberFormatException("Byte array values must be hex enclosed in {}");
            }
            this.setRawValueBytesString(valueString.substring(1, valueString.length() - 1));
            return;
        }
        this.setRawValueIntString(valueString);
    }

    public void setRawValueBytesString(String bytesString) {
        this.setRawValueBytes(NumericUtilities.convertStringToBytes((String)bytesString));
    }

    public void setRawValueIntString(String intString) {
        BigInteger val = (intString = intString.trim()).startsWith("0x") ? new BigInteger(intString.substring(2), 16) : new BigInteger(intString, 10);
        this.setRawValueBytes(Utils.bigIntegerToBytes((BigInteger)val, (int)this.value.length, (boolean)this.provider.language.isBigEndian()));
    }

    public void setRawValueBytes(byte[] bytes) {
        DebuggerControlService controlService;
        if (this.address == null) {
            throw new IllegalStateException("Cannot write to watch variable without an address");
        }
        if (bytes.length > this.value.length) {
            throw new IllegalArgumentException("Byte arrays cannot exceed length of variable");
        }
        if (bytes.length < this.value.length) {
            byte[] fillOld = Arrays.copyOf(this.value, this.value.length);
            System.arraycopy(bytes, 0, fillOld, 0, bytes.length);
            bytes = fillOld;
        }
        if ((controlService = this.provider.controlService) == null) {
            throw new AssertionError((Object)"No control service");
        }
        DebuggerControlService.StateEditor editor = controlService.createStateEditor(this.provider.current);
        editor.setVariable(this.address, bytes).exceptionally(ex -> {
            Msg.showError((Object)this, null, (String)"Write Failed", (Object)"Could not modify watch value (on target)", (Throwable)ex);
            return null;
        });
    }

    public void setValueString(String valueString) {
        if (this.dataType == null || this.value == null) {
            this.provider.getTool().setStatusInfo("Watch no value or no data type", true);
            return;
        }
        try {
            byte[] encoded = this.dataType.encodeRepresentation(valueString, (MemBuffer)new ByteMemBufferImpl(this.address, this.value, this.provider.language.isBigEndian()), SettingsImpl.NO_SETTINGS, this.value.length);
            this.setRawValueBytes(encoded);
        }
        catch (DataTypeEncodeException e) {
            this.provider.getTool().setStatusInfo(e.getMessage(), true);
        }
    }

    public boolean isValueEditable() {
        if (!this.isRawValueEditable()) {
            return false;
        }
        if (this.dataType == null) {
            return false;
        }
        return this.dataType.isEncodable();
    }

    public int getValueLength() {
        return this.value == null ? 0 : this.value.length;
    }

    protected Symbol computeSymbol() {
        if (this.address == null || !this.address.isMemoryAddress()) {
            return null;
        }
        DebuggerCoordinates current = this.provider.current;
        Trace trace = current.getTrace();
        Collection labels = trace.getSymbolManager().labels().getAt(current.getSnap(), null, this.address, false);
        if (!labels.isEmpty()) {
            return (Symbol)labels.iterator().next();
        }
        if (this.provider.mappingService == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(trace, null, Lifespan.at((long)current.getSnap()), this.address);
        ProgramLocation sloc = this.provider.mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        Program program = sloc.getProgram();
        SymbolTable table = program.getSymbolTable();
        Symbol primary = table.getPrimarySymbol(this.address);
        if (primary != null) {
            return primary;
        }
        SymbolIterator sit = table.getSymbolsAsIterator(sloc.getByteAddress());
        if (sit.hasNext()) {
            return sit.next();
        }
        Function function = program.getFunctionManager().getFunctionContaining(this.address);
        if (function != null) {
            return function.getSymbol();
        }
        return null;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String getErrorMessage() {
        if (this.error == null) {
            return "";
        }
        String message = this.error.getMessage();
        if (message != null && message.trim().length() != 0) {
            return message;
        }
        return this.error.getClass().getSimpleName();
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isKnown() {
        return this.state == TraceMemoryState.KNOWN;
    }

    public boolean isChanged() {
        if (this.prevValue == null) {
            return false;
        }
        return !Arrays.equals(this.value, this.prevValue);
    }

    protected void writeConfigState(SaveState saveState) {
        saveState.putString(KEY_EXPRESSION, this.expression);
        saveState.putString(KEY_DATA_TYPE, this.typePath);
        saveState.putSaveState(KEY_SETTINGS, this.savedSettings.getState());
    }

    protected void readConfigState(SaveState saveState) {
        this.setExpression(saveState.getString(KEY_EXPRESSION, ""));
        this.setTypePath(saveState.getString(KEY_DATA_TYPE, null));
        this.savedSettings.setState(saveState.getSaveState(KEY_SETTINGS));
        if (this.dataType != null) {
            this.savedSettings.read(this.dataType.getSettingsDefinitions(), this.dataType.getDefaultSettings());
        }
    }
}

