/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.target;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.ModelActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsProvider;
import ghidra.app.services.DebuggerModelService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger targets manager", description="GUI to manage connections to external debuggers and trace recording", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ModelActivatedPluginEvent.class}, servicesRequired={DebuggerModelService.class})
public class DebuggerTargetsPlugin
extends AbstractDebuggerPlugin {
    @AutoServiceConsumed
    protected DebuggerModelService modelService;
    protected DebuggerTargetsProvider provider;

    public DebuggerTargetsPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerTargetsProvider(this);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ModelActivatedPluginEvent) {
            ModelActivatedPluginEvent evt = (ModelActivatedPluginEvent)event;
            this.provider.modelActivated(evt.getActiveModel());
        }
    }
}

