/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.target;

import docking.widgets.tree.SearchableByObjectGTreeNode;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.target.DebuggerModelNode;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsProvider;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.util.Swing;
import ghidra.util.datastruct.CollectionChangeListener;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DebuggerConnectionsNode
extends DebuggerResources.AbstractDebuggerConnectionsNode
implements SearchableByObjectGTreeNode {
    private final DebuggerModelService service;
    private final DebuggerTargetsProvider provider;
    private final Map<DebuggerObjectModel, DebuggerModelNode> models = new HashMap<DebuggerObjectModel, DebuggerModelNode>();
    private final ModelsChangedListener modelsChangedListener = new ModelsChangedListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerConnectionsNode(DebuggerModelService service, DebuggerTargetsProvider provider) {
        this.service = service;
        this.provider = provider;
        if (service == null) {
            return;
        }
        service.addModelsChangedListener(this.modelsChangedListener);
        LinkedHashSet<DebuggerModelNode> toAdd = new LinkedHashSet<DebuggerModelNode>();
        Map<DebuggerObjectModel, DebuggerModelNode> map = this.models;
        synchronized (map) {
            Set<DebuggerObjectModel> current = service.getModels();
            for (DebuggerObjectModel element : current) {
                DebuggerModelNode node = new DebuggerModelNode(element, provider);
                this.models.put(element, node);
                toAdd.add(node);
            }
        }
        for (DebuggerModelNode node : toAdd) {
            this.addNode(node);
        }
    }

    public void dispose() {
        this.service.removeModelsChangedListener(this.modelsChangedListener);
        super.dispose();
    }

    public boolean isLeaf() {
        return false;
    }

    public DebuggerModelService getTargetService() {
        return this.service;
    }

    public Map<? extends Object, ? extends DebuggerModelNode> getObjectNodeMap() {
        return this.models;
    }

    protected class ModelsChangedListener
    implements CollectionChangeListener<DebuggerObjectModel> {
        protected ModelsChangedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementAdded(DebuggerObjectModel element) {
            DebuggerModelNode node;
            Map<DebuggerObjectModel, DebuggerModelNode> map = DebuggerConnectionsNode.this.models;
            synchronized (map) {
                if (DebuggerConnectionsNode.this.models.containsKey(element)) {
                    return;
                }
                node = new DebuggerModelNode(element, DebuggerConnectionsNode.this.provider);
                DebuggerConnectionsNode.this.models.put(element, node);
            }
            Swing.runIfSwingOrRunLater(() -> {
                DebuggerConnectionsNode.this.addNode(node);
                DebuggerConnectionsNode.this.expand();
            });
        }

        public void elementModified(DebuggerObjectModel element) {
            DebuggerConnectionsNode.this.fireNodeChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementRemoved(DebuggerObjectModel element) {
            DebuggerModelNode node;
            Map<DebuggerObjectModel, DebuggerModelNode> map = DebuggerConnectionsNode.this.models;
            synchronized (map) {
                node = DebuggerConnectionsNode.this.models.remove(element);
                if (node == null) {
                    return;
                }
            }
            Swing.runIfSwingOrRunLater(() -> DebuggerConnectionsNode.this.removeNode(node));
        }
    }
}

