/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import docking.menu.MultiStateDockingAction;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangeManager;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.MemoryByteBlock;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerLocationLabel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerReadsMemoryTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerTrackLocationTrait;
import ghidra.app.plugin.core.debug.gui.action.GoToInput;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.memory.CachedBytePage;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesPanel;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesPlugin;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class DebuggerMemoryBytesProvider
extends ProgramByteViewerComponentProvider {
    private static final AutoConfigState.ClassHandler<ProgramByteViewerComponentProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(ProgramByteViewerComponentProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    private final AutoReadMemorySpec defaultReadMemorySpec = AutoReadMemorySpec.fromConfigName("READ_VIS_RO_ONCE");
    private final DebuggerMemoryBytesPlugin myPlugin;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    protected DockingAction actionGoTo;
    protected ToggleDockingAction actionFollowsCurrentThread;
    protected MultiStateDockingAction<AutoReadMemorySpec> actionAutoReadMemory;
    protected DockingAction actionRefreshSelectedMemory;
    protected MultiStateDockingAction<LocationTrackingSpec> actionTrackLocation;
    protected ForMemoryBytesGoToTrait goToTrait;
    protected ForMemoryBytesTrackingTrait trackingTrait;
    protected ForMemoryBytesReadsMemoryTrait readsMemTrait;
    protected final DebuggerLocationLabel locationLabel = new DebuggerLocationLabel();
    protected final JLabel trackingLabel = new JLabel();
    @AutoConfigStateField
    protected boolean followsCurrentThread = true;
    @AutoConfigStateField(codec=AutoReadMemorySpec.AutoReadMemorySpecConfigFieldCodec.class)
    protected AutoReadMemorySpec autoReadMemorySpec = this.defaultReadMemorySpec;
    private final ListenerForChanges listenerForChanges = new ListenerForChanges();
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    private final CachedBytePage currCache = new CachedBytePage();
    private final CachedBytePage prevCache = new CachedBytePage();
    protected final boolean isMainViewer;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getRecorder(), b.getRecorder())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    protected DebuggerMemoryBytesProvider(PluginTool tool, DebuggerMemoryBytesPlugin plugin, boolean isConnected) {
        super(tool, (AbstractByteViewerPlugin)plugin, "Memory", isConnected);
        this.myPlugin = plugin;
        this.isMainViewer = isConnected;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.createActions();
        this.addDisplayListener(this.readsMemTrait.getDisplayListener());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.locationLabel, "West");
        northPanel.add((Component)this.trackingLabel, "East");
        this.decorationComponent.add((Component)northPanel, (Object)"North");
        this.goToTrait.goToCoordinates(this.current);
        this.trackingTrait.goToCoordinates(this.current);
        this.readsMemTrait.goToCoordinates(this.current);
        this.locationLabel.goToCoordinates(this.current);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MEMORY_BYTES);
        this.trackingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerMemoryBytesProvider.this.doGoToTracked();
                }
            }
        });
    }

    protected ByteBlockChangeManager newByteBlockChangeManager(final ProgramByteBlockSet blockSet, ByteBlockChangeManager bbcm) {
        return new ByteBlockChangeManager(blockSet, bbcm){

            protected boolean isChanged(ByteBlock block, BigInteger offset, int unitByteSize) {
                if (super.isChanged(block, offset, unitByteSize)) {
                    return true;
                }
                if (DebuggerMemoryBytesProvider.this.previous.getTrace() != DebuggerMemoryBytesProvider.this.current.getTrace()) {
                    return false;
                }
                Address address = blockSet.getAddress(block, offset);
                if (address == null) {
                    return false;
                }
                return DebuggerMemoryBytesProvider.this.currCache.getByte(DebuggerMemoryBytesProvider.this.current, address) != DebuggerMemoryBytesProvider.this.prevCache.getByte(DebuggerMemoryBytesProvider.this.previous, address);
            }
        };
    }

    protected ProgramByteBlockSet newByteBlockSet(ByteBlockChangeManager changeManager) {
        if (this.program == null) {
            return null;
        }
        return new ProgramByteBlockSet(this, this.program, changeManager){

            protected MemoryByteBlock newMemoryByteBlock(Memory memory, MemoryBlock memBlock) {
                return new MemoryByteBlock(this.program, memory, memBlock){

                    protected boolean editAllowed(Address addr, long length) {
                        return true;
                    }
                };
            }
        };
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    protected void initTraits() {
        if (this.goToTrait == null) {
            this.goToTrait = new ForMemoryBytesGoToTrait();
        }
        if (this.trackingTrait == null) {
            this.trackingTrait = new ForMemoryBytesTrackingTrait();
        }
        if (this.readsMemTrait == null) {
            this.readsMemTrait = new ForMemoryBytesReadsMemoryTrait();
        }
    }

    protected ByteViewerPanel newByteViewerPanel() {
        this.initTraits();
        return new DebuggerMemoryBytesPanel(this);
    }

    protected ByteViewerPanel getByteViewerPanel() {
        return super.getByteViewerPanel();
    }

    protected void addToToolbar() {
    }

    protected DebuggerCoordinates getCurrent() {
        return this.current == null ? DebuggerCoordinates.NOWHERE : this.current;
    }

    protected String computeSubTitle() {
        String specTitle;
        LocationTrackingSpec trackingSpec;
        DebuggerCoordinates current = this.getCurrent();
        TraceProgramView view = current == null ? null : current.getView();
        ArrayList<String> parts = new ArrayList<String>();
        LocationTrackingSpec locationTrackingSpec = trackingSpec = this.trackingTrait == null ? null : this.trackingTrait.getSpec();
        if (trackingSpec != null && (specTitle = trackingSpec.computeTitle(current)) != null) {
            parts.add(specTitle);
        }
        if (view != null) {
            parts.add(current.getTrace().getDomainFile().getName());
        }
        return StringUtils.join(parts, (String)", ");
    }

    protected void updateTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    protected void createActions() {
        this.initTraits();
        if (!this.isMainViewer()) {
            this.actionFollowsCurrentThread = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FollowsCurrentThreadAction.builder((Plugin)this.plugin).enabled(true)).selected(true).onAction(ctx -> this.doSetFollowsCurrentThread(this.actionFollowsCurrentThread.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        }
        this.actionGoTo = this.goToTrait.installAction();
        this.actionTrackLocation = this.trackingTrait.installAction();
        this.actionAutoReadMemory = this.readsMemTrait.installAutoReadAction();
        this.actionRefreshSelectedMemory = this.readsMemTrait.installRefreshSelectedAction();
    }

    protected void doSetProgram(Program newProgram) {
        if (newProgram != null && newProgram != this.current.getView()) {
            throw new AssertionError();
        }
        if (this.getProgram() == newProgram) {
            return;
        }
        if (newProgram != null && !(newProgram instanceof TraceProgramView)) {
            throw new IllegalArgumentException("Dynamic Listings require trace views");
        }
        super.doSetProgram(newProgram);
        if (newProgram != null) {
            this.setSelection(new ProgramSelection());
        }
        this.updateTitle();
        this.locationLabel.updateLabel();
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        if (location == null) {
            return false;
        }
        if (this.blockSet == null || this.blockSet.getByteBlockInfo(location.getAddress()) == null) {
            return false;
        }
        if (!super.goTo(gotoProgram, location)) {
            return false;
        }
        this.locationLabel.goToAddress(location.getAddress());
        return true;
    }

    protected void removeOldListeners() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().removeListener((DomainObjectListener)this.listenerForChanges);
        }
    }

    protected void addNewListeners() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().addListener((DomainObjectListener)this.listenerForChanges);
        }
    }

    protected DebuggerCoordinates adjustCoordinates(DebuggerCoordinates coordinates) {
        if (this.followsCurrentThread) {
            return coordinates;
        }
        return this.current.time(coordinates.getTime());
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        if (DebuggerMemoryBytesProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.previous = this.current;
        this.removeOldListeners();
        this.current = coordinates;
        this.addNewListeners();
        this.doSetProgram((Program)this.current.getView());
        this.goToTrait.goToCoordinates(coordinates);
        this.trackingTrait.goToCoordinates(coordinates);
        this.readsMemTrait.goToCoordinates(coordinates);
        this.locationLabel.goToCoordinates(coordinates);
        this.updateTitle();
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        DebuggerCoordinates adjusted = this.adjustCoordinates(coordinates);
        this.goToCoordinates(adjusted);
        if (adjusted.getTrace() == null) {
            this.trackingLabel.setText("");
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        }
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.goToCoordinates(DebuggerCoordinates.NOWHERE);
        }
    }

    public void setFollowsCurrentThread(boolean follows) {
        if (this.isMainViewer()) {
            throw new IllegalStateException("The main memory bytes viewer always follows the current trace and thread");
        }
        this.actionFollowsCurrentThread.setSelected(follows);
        this.doSetFollowsCurrentThread(follows);
    }

    protected void doSetFollowsCurrentThread(boolean follows) {
        this.followsCurrentThread = follows;
        this.updateBorder();
        this.updateTitle();
        this.coordinatesActivated(this.traceManager.getCurrent());
    }

    protected void updateBorder() {
        this.decorationComponent.setConnected(this.followsCurrentThread);
    }

    public boolean isFollowsCurrentThread() {
        return this.followsCurrentThread;
    }

    public void setAutoReadMemorySpec(AutoReadMemorySpec spec) {
        this.readsMemTrait.setAutoSpec(spec);
    }

    public AutoReadMemorySpec getAutoReadMemorySpec() {
        return this.readsMemTrait.getAutoSpec();
    }

    protected void goToAndUpdateTrackingLabel(TraceProgramView curView, ProgramLocation loc) {
        this.trackingLabel.setText(this.trackingTrait.computeLabelText());
        if (this.goTo((Program)curView, loc)) {
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        } else {
            this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.ERROR);
        }
    }

    protected void doGoToTracked() {
        if (this.editModeAction.isSelected()) {
            return;
        }
        ProgramLocation loc = this.trackingTrait.getTrackedLocation();
        if (loc == null) {
            return;
        }
        TraceProgramView curView = this.current.getView();
        Swing.runIfSwingOrRunLater(() -> {
            if (curView != this.current.getView()) {
                return;
            }
            this.goToAndUpdateTrackingLabel(curView, loc);
        });
    }

    public void setTrackingSpec(LocationTrackingSpec spec) {
        this.trackingTrait.setSpec(spec);
    }

    public LocationTrackingSpec getTrackingSpec() {
        return this.trackingTrait.getSpec();
    }

    public boolean isConnected() {
        return false;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isMainViewer() {
        return this.isMainViewer;
    }

    protected void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
    }

    protected void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.trackingTrait.readConfigState(saveState);
        if (this.isMainViewer()) {
            this.followsCurrentThread = true;
        } else {
            this.actionFollowsCurrentThread.setSelected(this.followsCurrentThread);
            this.updateBorder();
        }
    }

    protected void writeDataState(SaveState saveState) {
        if (!this.isMainViewer()) {
            this.current.writeDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
        }
        super.writeDataState(saveState);
    }

    protected void readDataState(SaveState saveState) {
        if (!this.isMainViewer()) {
            DebuggerCoordinates coordinates = DebuggerCoordinates.readDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
            this.coordinatesActivated(coordinates);
        }
        super.readDataState(saveState);
    }

    protected void updateLocation(ByteBlock block, BigInteger blockOffset, int column, boolean export) {
        super.updateLocation(block, blockOffset, column, export);
        this.locationLabel.goToAddress(this.currentLocation == null ? null : this.currentLocation.getAddress());
    }

    public void cloneWindow() {
        DebuggerMemoryBytesProvider newProvider = (DebuggerMemoryBytesProvider)this.myPlugin.createNewDisconnectedProvider();
        ViewerPosition vp = this.panel.getViewerPosition();
        SaveState saveState = new SaveState();
        this.writeConfigState(saveState);
        Swing.runLater(() -> {
            newProvider.readConfigState(saveState);
            newProvider.goToCoordinates(this.current);
            newProvider.setLocation(this.currentLocation);
            newProvider.panel.setViewerPosition(vp);
        });
    }

    protected class ListenerForChanges
    extends TraceDomainObjectListener {
        public ListenerForChanges() {
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
        }

        private void bytesChanged(TraceAddressSpace space) {
            if (space.getAddressSpace().isMemorySpace()) {
                DebuggerMemoryBytesProvider.this.currCache.invalidate();
                DebuggerMemoryBytesProvider.this.prevCache.invalidate();
            }
        }
    }

    protected class ForMemoryBytesReadsMemoryTrait
    extends DebuggerReadsMemoryTrait {
        public ForMemoryBytesReadsMemoryTrait() {
            super(DebuggerMemoryBytesProvider.this.tool, (Plugin)DebuggerMemoryBytesProvider.this.plugin, (ComponentProvider)DebuggerMemoryBytesProvider.this);
        }

        @Override
        protected AddressSetView getSelection() {
            return DebuggerMemoryBytesProvider.this.getSelection();
        }

        @Override
        protected void repaintPanel() {
            for (ByteViewerComponent view : DebuggerMemoryBytesProvider.this.getByteViewerPanel().getViewList()) {
                view.repaint();
            }
        }
    }

    protected class ForMemoryBytesGoToTrait
    extends DebuggerGoToTrait {
        public ForMemoryBytesGoToTrait() {
            super(DebuggerMemoryBytesProvider.this.tool, (Plugin)DebuggerMemoryBytesProvider.this.plugin, (ComponentProvider)DebuggerMemoryBytesProvider.this);
        }

        @Override
        protected GoToInput getDefaultInput() {
            return DebuggerMemoryBytesProvider.this.trackingTrait.getDefaultGoToInput(DebuggerMemoryBytesProvider.this.currentLocation);
        }

        @Override
        protected boolean goToAddress(Address address) {
            TraceProgramView view = this.current.getView();
            if (view == null) {
                return false;
            }
            return DebuggerMemoryBytesProvider.this.goTo((Program)view, new ProgramLocation((Program)view, address));
        }
    }

    protected class ForMemoryBytesTrackingTrait
    extends DebuggerTrackLocationTrait {
        public ForMemoryBytesTrackingTrait() {
            super(DebuggerMemoryBytesProvider.this.tool, (Plugin)DebuggerMemoryBytesProvider.this.plugin, (ComponentProvider)DebuggerMemoryBytesProvider.this);
        }

        @Override
        protected void locationTracked() {
            DebuggerMemoryBytesProvider.this.doGoToTracked();
        }

        @Override
        protected void specChanged(LocationTrackingSpec spec) {
            DebuggerMemoryBytesProvider.this.updateTitle();
            DebuggerMemoryBytesProvider.this.trackingLabel.setText("");
            DebuggerMemoryBytesProvider.this.trackingLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        }
    }
}

