/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DisassemblyResult;
import ghidra.framework.cmd.TypedBackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;

public class CurrentPlatformTraceDisassembleAction
extends DockingAction {
    private static final String NAME = "Disassemble";
    private static final String MENU_GROUP = "Disassembly";
    private static final KeyBindingData KEY_BINDING = new KeyBindingData("D");
    private final DebuggerDisassemblerPlugin plugin;

    public CurrentPlatformTraceDisassembleAction(DebuggerDisassemblerPlugin plugin) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{NAME}, MENU_GROUP));
        this.setKeyBindingData(KEY_BINDING);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "disassemble"));
    }

    protected DebuggerDisassemblerPlugin.Reqs getReqs(ActionContext context) {
        if (this.plugin.platformService == null) {
            return null;
        }
        if (!(context instanceof ListingActionContext)) {
            return null;
        }
        ListingActionContext lac = (ListingActionContext)context;
        Program program = lac.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return null;
        }
        TraceProgramView view = (TraceProgramView)program;
        Trace trace = view.getTrace();
        DebuggerCoordinates current = this.plugin.traceManager == null ? DebuggerCoordinates.NOWHERE : this.plugin.traceManager.getCurrentFor(trace);
        TraceThread thread = current.getThread();
        TraceObject object = current.getObject();
        DebuggerPlatformMapper mapper = this.plugin.platformService.getMapper(trace, object, view.getSnap());
        return new DebuggerDisassemblerPlugin.Reqs(mapper, thread, object, view);
    }

    public boolean isAddToPopup(ActionContext context) {
        DebuggerDisassemblerPlugin.Reqs reqs = this.getReqs(context);
        return reqs != null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DebuggerDisassemblerPlugin.Reqs reqs = this.getReqs(context);
        if (reqs == null) {
            return false;
        }
        return super.isEnabledForContext(context);
    }

    public void actionPerformed(ActionContext context) {
        final DebuggerDisassemblerPlugin.Reqs reqs = this.getReqs(context);
        if (reqs == null) {
            return;
        }
        ListingActionContext lac = (ListingActionContext)context;
        final Address address = lac.getAddress();
        AddressSpace space = address.getAddressSpace();
        ProgramSelection selection = lac.getSelection();
        Object set = selection != null && !selection.isEmpty() ? selection : reqs.view.getAddressFactory().getAddressSet(space.getMinAddress(), space.getMaxAddress());
        TypedBackgroundCommand<TraceProgramView> cmd = new TypedBackgroundCommand<TraceProgramView>(NAME, true, true, false, (AddressSetView)set){
            final /* synthetic */ AddressSetView val$set;
            {
                this.val$set = addressSetView;
                super(arg0, arg1, arg2, arg3);
            }

            public boolean applyToTyped(TraceProgramView view, TaskMonitor monitor) {
                DisassemblyResult result = reqs.mapper.disassemble(reqs.thread, reqs.object, address, this.val$set, view.getSnap(), monitor);
                if (!result.isSuccess()) {
                    CurrentPlatformTraceDisassembleAction.this.plugin.getTool().setStatusInfo(result.getErrorMessage(), true);
                }
                return true;
            }
        };
        cmd.run(this.plugin.getTool(), (UndoableDomainObject)reqs.view);
    }
}

