/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.model.iface1.FridaModelTargetFocusScope;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetStack;
import agent.frida.model.iface2.FridaModelTargetStackFrame;
import agent.frida.model.iface2.FridaModelTargetThread;
import agent.frida.model.impl.FridaModelTargetFunctionImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetThreadImpl;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="StackFrame", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Function", type=FridaModelTargetFunctionImpl.class), @TargetAttributeType(name="function", type=String.class), @TargetAttributeType(name="Inst. Offset", type=String.class), @TargetAttributeType(name="Frame Offset", type=String.class), @TargetAttributeType(name="Return Offset", type=String.class), @TargetAttributeType(name="Call Frame Offset", type=String.class), @TargetAttributeType(name="Stack Offset", type=String.class), @TargetAttributeType(type=Void.class)})
public class FridaModelTargetStackFrameImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetStackFrame {
    protected final FridaModelTargetThread thread;
    protected Address pc;
    protected String func;
    protected String file;
    protected String module;
    protected Long line;
    protected String display;
    private final FridaModelTargetFunctionImpl function;

    protected static String indexFrame(FridaFrame frame) {
        return FridaClient.getId(frame);
    }

    protected static String keyFrame(FridaFrame frame) {
        return PathUtils.makeKey((String)FridaModelTargetStackFrameImpl.indexFrame(frame));
    }

    public FridaModelTargetStackFrameImpl(FridaModelTargetStack stack, FridaModelTargetThread thread, FridaFrame frame) {
        super(stack.getModel(), (TargetObject)stack, FridaModelTargetStackFrameImpl.keyFrame(frame), frame, "StackFrame");
        this.thread = thread;
        this.pc = this.getModel().getAddressSpace("ram").getAddress(-1L);
        this.function = new FridaModelTargetFunctionImpl(this, frame.getFunction());
        this.display = FridaModelTargetStackFrameImpl.computeDisplay(frame);
        this.changeAttributes(List.of(), List.of(this.function), Map.of("_display", this.display, "_pc", this.pc), "Initialized");
        this.setFrame(frame);
        this.getManager().addEventsListener(this);
    }

    protected static String computeDisplay(FridaFrame frame) {
        if (frame.getFunctionName() == null) {
            frame.getPC();
            return String.format("#%s 0x%s", FridaClient.getId(frame), Long.toHexString(frame.getPC()));
        }
        return String.format("#%s 0x%s in %s ()", FridaClient.getId(frame), Long.toHexString(frame.getPC()), frame.getFunctionName());
    }

    @Override
    public void threadSelected(FridaThread eventThread, FridaFrame eventFrame, FridaCause cause) {
        if (eventFrame != null && eventFrame.equals(this.getFrame())) {
            ((FridaModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void setFrame(FridaFrame frame) {
        this.setModelObject(frame);
        Long address = frame.getPC();
        long lval = address == null ? -1L : address;
        this.pc = this.getModel().getAddressSpace("ram").getAddress(lval);
        this.func = frame.getFunctionName();
        if (this.func == null) {
            this.func = "UNKNOWN";
        }
        this.file = frame.getFileName();
        if (this.file == null) {
            this.file = "UNKNOWN";
        }
        this.module = frame.getModuleName();
        if (this.module == null) {
            this.module = "UNKNOWN";
        }
        this.line = frame.getLineNumber();
        this.changeAttributes(List.of(), List.of(), Map.of("_pc", this.pc, "function", this.func), "Refreshed");
    }

    @Override
    public TargetObject getThread() {
        return this.thread;
    }

    public FridaFrame getFrame() {
        return (FridaFrame)this.getModelObject();
    }

    @Override
    public Address getPC() {
        return this.pc;
    }

    @Override
    public FridaModelTargetProcess getProcess() {
        return ((FridaModelTargetThreadImpl)this.thread).getProcess();
    }

    public void threadStateChangedSpecific(FridaState state, FridaReason reason) {
        this.setFrame(this.getFrame());
    }
}

