/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaThreadInfo;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaThread;
import agent.frida.manager.evt.FridaStateChangedEvent;
import agent.frida.manager.evt.FridaThreadSelectedEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import agent.frida.model.impl.FridaModelImpl;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.DebuggerCallbackReorderer;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.util.datastruct.PrivatelyQueuedListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@DebuggerBotInfo(description="Link debugger to Frida", details="Listens for debuggers to add state to Frida.", help=@HelpInfo(anchor="link_frida"), enabledByDefault=true)
public class FridaDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;
    private FridaObjectListener listener = new FridaObjectListener();
    private List<DebuggerObjectModel> models = new ArrayList<DebuggerObjectModel>();
    private FridaModelImpl primary;
    private FridaManagerImpl manager;

    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
    }

    public boolean isEnabled() {
        return this.plugin != null;
    }

    public void disable() {
        this.plugin = null;
    }

    public void modelAdded(DebuggerObjectModel model) {
        this.models.add(model);
        if (model instanceof FridaModelImpl) {
            this.primary = (FridaModelImpl)model;
            this.manager = this.primary.getManager();
        } else {
            model.addModelListener(this.getListener(), true);
        }
    }

    public void modelRemoved(DebuggerObjectModel model) {
        this.models.remove(model);
        if (model instanceof FridaModelImpl) {
            this.primary = null;
            this.manager = null;
        } else {
            model.removeModelListener(this.getListener());
        }
    }

    public DebuggerModelListener getListener() {
        return (DebuggerModelListener)this.listener.queue.in;
    }

    private Object findMatchingObject(TargetObject object) {
        TargetProcess tp;
        Object found;
        if (object instanceof TargetProcess) {
            String id = Long.toHexString(((TargetProcess)object).getPid());
            return this.manager.getProcess(this.manager.getCurrentSession(), id);
        }
        if (object instanceof TargetThread && (found = this.findMatchingObject((TargetObject)(tp = (TargetProcess)DebugModelConventions.ancestor(TargetProcess.class, (TargetObject)object)))) != null) {
            FridaProcess process = (FridaProcess)found;
            String id = Long.toHexString(((TargetThread)object).getTid());
            return this.manager.getThread(process, id);
        }
        return null;
    }

    class FridaObjectListener
    extends AnnotatedDebuggerAttributeListener {
        protected final DebuggerCallbackReorderer reorderer;
        protected final PrivatelyQueuedListener<DebuggerModelListener> queue;

        public FridaObjectListener() {
            super(MethodHandles.lookup());
            this.reorderer = new DebuggerCallbackReorderer((DebuggerModelListener)this);
            this.queue = new PrivatelyQueuedListener(DebuggerModelListener.class, "ObjectsProvider-EventQueue", (Object)this.reorderer);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_accessible")
        public void accessibilityChanged(TargetObject object, boolean accessible) {
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel channel, String out) {
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_display")
        public void displayChanged(TargetObject object, String display) {
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_modified")
        public void modifiedChanged(TargetObject object, boolean modified) {
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
        public void executionStateChanged(TargetObject object, TargetExecutionStateful.TargetExecutionState state) {
            Object localObject;
            if (FridaDebuggerBot.this.primary != null && (localObject = FridaDebuggerBot.this.findMatchingObject(object)) != null) {
                FridaDebuggerBot.this.manager.processEvent(new FridaStateChangedEvent(localObject, state));
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
        public void focusChanged(TargetObject object, TargetObject focused) {
            Object localObject;
            if (FridaDebuggerBot.this.primary != null && focused instanceof TargetThread && (localObject = FridaDebuggerBot.this.findMatchingObject(focused)) != null) {
                FridaThreadInfo info = new FridaThreadInfo((FridaThread)localObject);
                FridaDebuggerBot.this.manager.processEvent(new FridaThreadSelectedEvent(info));
            }
        }

        public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
        }

        public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_prompt")
        public void promptChanged(TargetObject interpreter, String prompt) {
        }

        public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
        }

        public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
        }

        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            super.attributesChanged(parent, removed, added);
        }
    }
}

