/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public abstract class RangeMapSetter<E, D, R, V> {
    protected abstract int compare(D var1, D var2);

    protected abstract R getRange(E var1);

    protected abstract V getValue(E var1);

    protected abstract void remove(E var1);

    protected abstract D getLower(R var1);

    protected abstract D getUpper(R var1);

    protected abstract R toSpan(D var1, D var2);

    protected abstract D getPrevious(D var1);

    protected abstract D getNext(D var1);

    protected abstract Iterable<E> getIntersecting(D var1, D var2);

    protected abstract E put(R var1, V var2);

    protected D getPreviousOrSame(D d) {
        D prev = this.getPrevious(d);
        if (prev == null) {
            return d;
        }
        return prev;
    }

    protected D getNextOrSame(D d) {
        D next = this.getNext(d);
        if (next == null) {
            return d;
        }
        return next;
    }

    protected boolean connects(R r1, R r2) {
        return this.compare(this.getPreviousOrSame(this.getLower(r1)), this.getUpper(r2)) <= 0 || this.compare(this.getPreviousOrSame(this.getLower(r2)), this.getUpper(r1)) <= 0;
    }

    public E set(R range, V value) {
        return this.set(this.getLower(range), this.getUpper(range), value);
    }

    public E set(D lower, D upper, V value) {
        D prev = this.getPreviousOrSame(lower);
        D next = this.getNextOrSame(upper);
        LinkedHashSet<E> toRemove = new LinkedHashSet<E>();
        HashMap<R, V> toPut = new HashMap<R, V>();
        for (E entry : this.getIntersecting(prev, next)) {
            R r = this.getRange(entry);
            int cmpMin = this.compare(this.getLower(r), lower);
            int cmpMax = this.compare(this.getUpper(r), upper);
            boolean sameVal = Objects.equals(this.getValue(entry), value);
            if (cmpMin <= 0 && cmpMax >= 0 && sameVal) {
                return entry;
            }
            toRemove.add(entry);
            if (cmpMin < 0) {
                if (sameVal) {
                    lower = this.getLower(r);
                } else {
                    toPut.put(this.toSpan(this.getLower(r), prev), this.getValue(entry));
                }
            }
            if (cmpMax <= 0) continue;
            if (sameVal) {
                upper = this.getUpper(r);
                continue;
            }
            toPut.put(this.toSpan(next, this.getUpper(r)), this.getValue(entry));
        }
        for (E entry : toRemove) {
            this.remove(entry);
        }
        E result = this.put(this.toSpan(lower, upper), value);
        assert (toPut.size() <= 2);
        for (Map.Entry ent : toPut.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
        return result;
    }
}

