/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import generic.stl.Pair;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.importer.LcsHintLoadSpecChooser;
import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.importer.LoaderArgsOptionChooser;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.OptionChooser;
import ghidra.app.util.importer.SingleLoaderFilter;
import ghidra.app.util.opinion.BinaryLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class AutoImporter {
    private static final Predicate<Loader> BINARY_LOADER = new SingleLoaderFilter(BinaryLoader.class);

    private AutoImporter() {
    }

    public static LoadResults<Program> importByUsingBestGuess(File file, Project project, String projectFolderPath, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        return AutoImporter.importFresh(file, project, projectFolderPath, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, OptionChooser.DEFAULT_OPTIONS);
    }

    public static LoadResults<Program> importByUsingBestGuess(ByteProvider provider, Project project, String projectFolderPath, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        return AutoImporter.importFresh(provider, project, projectFolderPath, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, OptionChooser.DEFAULT_OPTIONS);
    }

    public static LoadResults<Program> importByUsingSpecificLoaderClass(File file, Project project, String projectFolderPath, Class<? extends Loader> loaderClass, List<Pair<String, String>> loaderArgs, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        SingleLoaderFilter loaderFilter = new SingleLoaderFilter(loaderClass, loaderArgs);
        return AutoImporter.importFresh(file, project, projectFolderPath, consumer, messageLog, monitor, (Predicate<Loader>)loaderFilter, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, null, (OptionChooser)new LoaderArgsOptionChooser(loaderFilter));
    }

    public static LoadResults<Program> importByLookingForLcs(File file, Project project, String projectFolderPath, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        return AutoImporter.importFresh(file, project, projectFolderPath, consumer, messageLog, monitor, LoaderService.ACCEPT_ALL, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS);
    }

    public static LoadResults<Program> importByUsingSpecificLoaderClassAndLcs(File file, Project project, String projectFolderPath, Class<? extends Loader> loaderClass, List<Pair<String, String>> loaderArgs, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        SingleLoaderFilter loaderFilter = new SingleLoaderFilter(loaderClass, loaderArgs);
        return AutoImporter.importFresh(file, project, projectFolderPath, consumer, messageLog, monitor, (Predicate<Loader>)loaderFilter, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, (OptionChooser)new LoaderArgsOptionChooser(loaderFilter));
    }

    public static Loaded<Program> importAsBinary(File file, Project project, String projectFolderPath, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        LoadResults<Program> loadResults = AutoImporter.importFresh(file, project, projectFolderPath, consumer, messageLog, monitor, BINARY_LOADER, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS);
        loadResults.releaseNonPrimary(consumer);
        return loadResults.getPrimary();
    }

    public static Loaded<Program> importAsBinary(ByteProvider bytes, Project project, String projectFolderPath, Language language, CompilerSpec compilerSpec, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        LoadResults<Program> loadResults = AutoImporter.importFresh(bytes, project, projectFolderPath, consumer, messageLog, monitor, BINARY_LOADER, (LoadSpecChooser)new LcsHintLoadSpecChooser(language, compilerSpec), null, OptionChooser.DEFAULT_OPTIONS);
        loadResults.releaseNonPrimary(consumer);
        return loadResults.getPrimary();
    }

    public static LoadResults<Program> importFresh(File file, Project project, String projectFolderPath, Object consumer, MessageLog messageLog, TaskMonitor monitor, Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, String importNameOverride, OptionChooser optionChooser) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        if (file == null) {
            throw new LoadException("Cannot load null file");
        }
        try (FileByteProvider provider = new FileByteProvider(file, FileSystemService.getInstance().getLocalFSRL(file), AccessMode.READ);){
            LoadResults<Program> loadResults = AutoImporter.importFresh(provider, project, projectFolderPath, consumer, messageLog, monitor, loaderFilter, loadSpecChooser, importNameOverride, optionChooser);
            return loadResults;
        }
    }

    public static LoadResults<Program> importFresh(ByteProvider provider, Project project, String projectFolderPath, Object consumer, MessageLog messageLog, TaskMonitor monitor, Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, String importNameOverride, OptionChooser optionChooser) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException, LoadException {
        List<Option> loaderOptions;
        if (provider == null) {
            throw new LoadException("Cannot load null provider");
        }
        LoadSpec loadSpec = AutoImporter.getLoadSpec(loaderFilter, loadSpecChooser, provider);
        if (loadSpec == null) {
            throw new LoadException("No load spec found");
        }
        String importName = loadSpec.getLoader().getPreferredFileName(provider);
        if (importNameOverride != null) {
            importName = importNameOverride;
        }
        LanguageCompilerSpecPair languageCompilerSpecPair = loadSpec.getLanguageCompilerSpec();
        AddressFactory addrFactory = null;
        if (languageCompilerSpecPair != null) {
            addrFactory = DefaultLanguageService.getLanguageService().getLanguage(languageCompilerSpecPair.languageID).getAddressFactory();
        }
        if ((loaderOptions = optionChooser.choose(loadSpec.getLoader().getDefaultOptions(provider, loadSpec, null, false), addrFactory)) == null) {
            throw new LoadException("Cannot load with null options");
        }
        Msg.info(AutoImporter.class, (Object)("Using Loader: " + loadSpec.getLoader().getName()));
        Msg.info(AutoImporter.class, (Object)("Using Language/Compiler: " + loadSpec.getLanguageCompilerSpec()));
        LoadResults<? extends DomainObject> loadResults = loadSpec.getLoader().load(provider, importName, project, projectFolderPath, loadSpec, loaderOptions, messageLog, consumer, monitor);
        ArrayList loadedPrograms = new ArrayList();
        for (Loaded<? extends DomainObject> loaded : loadResults) {
            DomainObject domainObject = loaded.getDomainObject();
            if (domainObject instanceof Program) {
                Program program = (Program)domainObject;
                loadedPrograms.add(new Loaded<Program>(program, loaded.getName(), loaded.getProjectFolderPath()));
                continue;
            }
            loaded.release(consumer);
        }
        if (loadedPrograms.isEmpty()) {
            throw new LoadException("Domain objects were loaded, but none were Programs");
        }
        return new LoadResults<Program>(loadedPrograms);
    }

    private static LoadSpec getLoadSpec(Predicate<Loader> loaderFilter, LoadSpecChooser loadSpecChooser, ByteProvider provider) {
        LoaderMap loaderMap = LoaderService.getSupportedLoadSpecs(provider, loaderFilter);
        LoadSpec loadSpec = loadSpecChooser.choose(loaderMap);
        if (loadSpec != null) {
            return loadSpec;
        }
        File f = provider.getFile();
        String name = f != null ? f.getAbsolutePath() : provider.getName();
        Msg.info(AutoImporter.class, (Object)("No load spec found for import file: " + name));
        return null;
    }
}

