/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.dialog;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.label.GLabel;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class AskAddrDialog
extends DialogComponentProvider {
    private boolean isCanceled;
    private AddressInput addrInput = new AddressInput();

    public AskAddrDialog(String title, String message, AddressFactory af, Address lastAddr) {
        super(title, true, true, true, false);
        this.addrInput.setAddressFactory(af);
        this.addrInput.selectDefaultAddressSpace();
        if (lastAddr != null) {
            this.addrInput.setAddress(lastAddr);
        }
        this.addrInput.select();
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel(message), "West");
        panel.add((Component)this.addrInput, "Center");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
    }

    protected void okCallback() {
        this.isCanceled = false;
        if (this.addrInput.getAddress() == null) {
            this.setStatusText("Please enter a valid ADDRESS.");
            return;
        }
        this.close();
    }

    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Address getValueAsAddress() {
        return this.addrInput.getAddress();
    }
}

