/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.attribs;

import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.program.model.scalar.Scalar;

public class DWARFNumericAttribute
extends Scalar
implements DWARFAttributeValue {
    private final boolean ambiguous;

    public DWARFNumericAttribute(long value) {
        this(64, value, true, false);
    }

    public DWARFNumericAttribute(int bitLength, long value, boolean signed) {
        this(bitLength, value, signed, false);
    }

    public DWARFNumericAttribute(int bitLength, long value, boolean signed, boolean ambiguous) {
        super(bitLength, value, signed);
        this.ambiguous = ambiguous;
    }

    public boolean isAmbiguousSignedness() {
        return this.ambiguous;
    }

    public long getValueWithSignednessHint(boolean signednessHint) {
        return this.getValue(this.ambiguous ? signednessHint : this.isSigned());
    }

    public String toString() {
        return String.format("DWARFNumericAttribute: %d [%08x]", this.getValue(), this.getValue());
    }
}

