/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractAnalyzer
implements Analyzer {
    private final String name;
    private final AnalyzerType type;
    private final String description;
    private boolean defaultEnablement = false;
    private boolean supportsOneTimeAnalysis;
    private boolean isPrototype = false;
    private AnalysisPriority priority = AnalysisPriority.LOW_PRIORITY;

    protected AbstractAnalyzer(String name, String description, AnalyzerType type) {
        this.name = name;
        this.type = type;
        this.description = description;
    }

    protected void setPriority(AnalysisPriority priority) {
        this.priority = priority;
    }

    protected void setDefaultEnablement(boolean b) {
        this.defaultEnablement = b;
    }

    protected void setSupportsOneTimeAnalysis() {
        this.supportsOneTimeAnalysis = true;
    }

    protected void setSupportsOneTimeAnalysis(boolean supportsOneTimeAnalysis) {
        this.supportsOneTimeAnalysis = supportsOneTimeAnalysis;
    }

    protected void setPrototype() {
        this.isPrototype = true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final AnalyzerType getAnalysisType() {
        return this.type;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        return this.defaultEnablement;
    }

    @Override
    public final boolean supportsOneTimeAnalysis() {
        return this.supportsOneTimeAnalysis;
    }

    @Override
    public final String getDescription() {
        return this.description == null ? "No Description" : this.description;
    }

    @Override
    public final AnalysisPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    @Override
    public boolean canAnalyze(Program program) {
        return true;
    }

    @Override
    public void optionsChanged(Options options, Program program) {
    }

    @Override
    public void analysisEnded(Program program) {
    }

    @Override
    public final boolean isPrototype() {
        return this.isPrototype;
    }

    @Override
    public void registerOptions(Options options, Program program) {
    }
}

