/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import generic.theme.GColor;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPlugin;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import java.awt.Color;

class LocationReferencesHighlighter {
    private static final String MARKER_SET_DESCRIPTION = "Shows the location of references currently displayed in the Location References window.";
    private static final String OPTIONS_TITLE = "Search";
    private static final String HIGHLIGHT_COLOR_KEY = "Reference Search.Highlight Match Color";
    private static final String HIGHLIGHT_COLOR_DESCRIPTION = "The highlight color of matches for the 'Show References' searcher";
    private static GColor DEFAULT_HIGHLIGHT_COLOR = new GColor("color.bg.plugin.locationreferences.highlight");
    private boolean isHighlighting = false;
    private final Navigatable navigatable;
    private LocationReferencesProvider provider;
    private LocationReferencesPlugin locationReferencesPlugin;
    private ListingHighlightProvider highlightProvider;
    private MarkerRemover markerRemover;
    private Color highlightColor;
    private OptionsChangeListener optionsListener = (options, name, oldValue, newValue) -> {
        if (name.equals(HIGHLIGHT_COLOR_KEY)) {
            this.highlightColor = (Color)newValue;
        }
    };

    static void registerHighlighterOptions(LocationReferencesPlugin plugin) {
        ToolOptions options = plugin.getTool().getOptions(OPTIONS_TITLE);
        options.registerThemeColorBinding(HIGHLIGHT_COLOR_KEY, DEFAULT_HIGHLIGHT_COLOR.getId(), plugin.getHelpLocation(), HIGHLIGHT_COLOR_DESCRIPTION);
    }

    LocationReferencesHighlighter(LocationReferencesPlugin locationReferencesPlugin, LocationReferencesProvider provider, Navigatable navigatable) {
        this.locationReferencesPlugin = locationReferencesPlugin;
        this.navigatable = navigatable;
        if (provider == null) {
            throw new NullPointerException("null provider not allowed.");
        }
        this.provider = provider;
        ToolOptions options2 = locationReferencesPlugin.getTool().getOptions(OPTIONS_TITLE);
        this.highlightColor = options2.getColor(HIGHLIGHT_COLOR_KEY, (Color)DEFAULT_HIGHLIGHT_COLOR);
        options2.addOptionsChangeListener(this.optionsListener);
    }

    void setHighlightingEnabled(boolean enabled) {
        this.isHighlighting = enabled;
        this.updateHighlights();
    }

    private void updateHighlights() {
        PluginTool tool = this.locationReferencesPlugin.getTool();
        if (tool == null) {
            return;
        }
        if (!this.navigatable.supportsHighlight()) {
            return;
        }
        Program activeProgram = this.navigatable.getProgram();
        Program providerProgram = this.provider.getProgram();
        if (this.isHighlighting && activeProgram != providerProgram) {
            return;
        }
        LocationDescriptor locationDescriptor = this.provider.getLocationDescriptor();
        DataTypeManagerService dataTypeManagerService = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        if (this.isHighlighting) {
            AddressSet set = this.provider.getReferenceAddresses(providerProgram);
            this.setHighlightMarkers(tool, set);
            this.highlightProvider = new LocationReferencesHighlightProvider();
            this.navigatable.setHighlightProvider(this.highlightProvider, providerProgram);
            this.selectDataType(dataTypeManagerService, locationDescriptor, true);
        } else {
            this.clearMarkers();
            this.selectDataType(dataTypeManagerService, locationDescriptor, false);
        }
    }

    private void setHighlightMarkers(PluginTool tool, AddressSet addressSet) {
        if (!this.navigatable.supportsMarkers()) {
            return;
        }
        this.clearMarkers();
        MarkerService markerService = (MarkerService)tool.getService(MarkerService.class);
        if (markerService == null) {
            return;
        }
        Program program = this.navigatable.getProgram();
        MarkerSet currentMarkerSet = markerService.createPointMarker("References To", MARKER_SET_DESCRIPTION, program, 50, false, true, false, this.highlightColor, null);
        markerService.removeMarker(currentMarkerSet, program);
        markerService.setMarkerForGroup("HIGHLIGHT_GROUP", currentMarkerSet, program);
        currentMarkerSet.add((AddressSetView)addressSet);
        this.markerRemover = new MarkerRemover(currentMarkerSet, markerService, program);
    }

    private void clearMarkers() {
        if (this.markerRemover != null) {
            this.markerRemover.dispose();
            this.markerRemover = null;
        }
        Program providerProgram = this.provider.getProgram();
        this.navigatable.removeHighlightProvider(this.highlightProvider, providerProgram);
    }

    private void selectDataType(DataTypeManagerService dataTypeManagerService, LocationDescriptor locationDescriptor, boolean enable) {
        if (!(locationDescriptor instanceof DataTypeLocationDescriptor)) {
            return;
        }
        if (dataTypeManagerService == null) {
            return;
        }
        DataTypeLocationDescriptor dataTypeDescriptor = (DataTypeLocationDescriptor)locationDescriptor;
        DataType locationDataType = null;
        if (enable) {
            locationDataType = dataTypeDescriptor.getSourceDataType();
            locationDataType = ReferenceUtils.getBaseDataType(locationDataType);
        }
        dataTypeManagerService.setDataTypeSelected(locationDataType);
    }

    LocationReferencesProvider getCurrentHighlightProvider() {
        return this.provider;
    }

    void dispose() {
        ToolOptions options = this.locationReferencesPlugin.getTool().getOptions(OPTIONS_TITLE);
        options.removeOptionsChangeListener(this.optionsListener);
        this.clearMarkers();
    }

    private class LocationReferencesHighlightProvider
    implements ListingHighlightProvider {
        private final Highlight[] NO_HIGHLIGHTS = new Highlight[0];

        private LocationReferencesHighlightProvider() {
        }

        @Override
        public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
            if (text == null) {
                return this.NO_HIGHLIGHTS;
            }
            LocationDescriptor locationDescriptor = LocationReferencesHighlighter.this.provider.getLocationDescriptor();
            ProxyObj<?> proxy = field.getProxy();
            Object obj = proxy.getObject();
            return locationDescriptor.getHighlights(text, obj, field.getFieldFactory().getClass(), LocationReferencesHighlighter.this.highlightColor);
        }
    }

    private class MarkerRemover {
        private final MarkerSet markerSet;
        private final MarkerService markerSerivce;
        private final Program program;

        private MarkerRemover(MarkerSet markerSet, MarkerService markerSerivce, Program program) {
            this.markerSet = markerSet;
            this.markerSerivce = markerSerivce;
            this.program = program;
        }

        void dispose() {
            this.markerSerivce.removeMarker(this.markerSet, this.program);
        }

        public String toString() {
            return "MarkerRemover [MarkerSet=" + this.markerSet.getName() + "]";
        }
    }
}

