/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.model;

import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.model.MaskContainer;
import ghidra.app.plugin.core.instructionsearch.model.OperandMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.AbstractInstructionTable;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTable;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;

public class InstructionSearchData
extends Observable {
    private List<InstructionMetadata> instructions = new ArrayList<InstructionMetadata>();

    public void registerForGuiUpdates(InstructionTable table) {
        table.getModel().addTableModelListener(e -> this.applyMasks(table));
    }

    public void applyMasks(InstructionTable table) {
        for (int row = 0; row < this.instructions.size(); ++row) {
            this.storeInstructionMask(table, row);
        }
        this.modelChanged(UpdateType.UPDATE);
    }

    public void load(Program program, AddressRange addressRange) throws InvalidInputException {
        AddressSet addrSet;
        this.instructions.clear();
        if (program == null || addressRange == null || addressRange.getLength() == 0L) {
            return;
        }
        Listing listing = program.getListing();
        CodeUnitIterator cuIter = listing.getCodeUnits((AddressSetView)(addrSet = new AddressSet(addressRange)), true);
        if (!cuIter.hasNext()) {
            throw new InvalidInputException("No instructions found in selection.");
        }
        TaskLauncher.launchModal((String)"Loading Instructions", monitor -> {
            monitor.setIndeterminate(true);
            while (cuIter.hasNext()) {
                InstructionMetadata instructionMetadata;
                if (monitor.isCancelled()) {
                    return;
                }
                CodeUnit cu = cuIter.next();
                if (cu instanceof Instruction) {
                    SleighDebugLogger logger = new SleighDebugLogger(program, cu.getAddress(), SleighDebugLogger.SleighDebugMode.VERBOSE);
                    if (logger.parseFailed()) {
                        Msg.showError((Object)this, null, (String)"Parsing error", (Object)("Error parsing instruction: " + cu.toString()));
                        return;
                    }
                    instructionMetadata = this.getInstructionMetadata(logger, cu);
                    if (instructionMetadata != null) {
                        this.instructions.add(instructionMetadata);
                    }
                    this.processOperands(logger, cu, instructionMetadata);
                    continue;
                }
                if (!(cu instanceof Data)) continue;
                try {
                    instructionMetadata = this.getInstructionMetadata(cu);
                    if (instructionMetadata == null) continue;
                    this.instructions.add(instructionMetadata);
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)this, null, (String)"Parsing error", (Object)("Error parsing data: " + cu.toString()));
                    return;
                }
            }
        });
        this.modelChanged(UpdateType.RELOAD);
    }

    public void clearAndReload() {
        if (this.instructions.isEmpty()) {
            return;
        }
        this.instructions.clear();
        this.modelChanged(UpdateType.RELOAD);
    }

    public List<InstructionMetadata> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<InstructionMetadata> instructions) {
        this.instructions = instructions;
        this.modelChanged(UpdateType.RELOAD);
    }

    public int getMaxNumOperands() {
        int numOperands = 0;
        for (InstructionMetadata instruction : this.instructions) {
            int numOperandsTemp = instruction.getOperands().size();
            if (numOperandsTemp <= numOperands) continue;
            numOperands = numOperandsTemp;
        }
        return numOperands;
    }

    public String getCombinedString() {
        return this.getAllMasks().toBinaryString();
    }

    public String getMaskString() {
        return this.getAllMasks().getMaskAsBinaryString();
    }

    public String getValueString() {
        return this.getAllMasks().getValueAsBinaryString();
    }

    public void maskOperandsByType(int operandType) {
        for (InstructionMetadata instruction : this.instructions) {
            List<OperandMetadata> operands = instruction.getOperands();
            for (OperandMetadata operand : operands) {
                switch (operandType) {
                    case 16384: {
                        if (!OperandType.isScalar((int)operand.getOpType())) break;
                        operand.setMasked(true);
                        break;
                    }
                    case 8192: {
                        if (!OperandType.isAddress((int)operand.getOpType())) break;
                        operand.setMasked(true);
                    }
                }
            }
        }
    }

    public void maskAllOperands() {
        for (InstructionMetadata instruction : this.instructions) {
            List<OperandMetadata> operands = instruction.getOperands();
            for (OperandMetadata operand : operands) {
                operand.setMasked(true);
            }
        }
    }

    private void modelChanged(UpdateType updateType) {
        this.setChanged();
        this.notifyObservers((Object)updateType);
    }

    private void storeInstructionMask(InstructionTable table, int row) {
        this.storeMnemonicMask(table, row);
        for (int i = 0; i < this.getMaxNumOperands(); ++i) {
            if (table.getCellData(row, i + 1) == null) continue;
            this.storeOperandMask(table, row, i);
        }
    }

    private void storeOperandMask(InstructionTable table, int row, int col) {
        if (row >= this.instructions.size()) {
            return;
        }
        if (col >= this.instructions.get(row).getOperands().size()) {
            return;
        }
        this.instructions.get(row).getOperands().get(col).setMasked(table.getCellData(row, col + 1).getState().equals((Object)AbstractInstructionTable.OperandState.MASKED));
    }

    private void storeMnemonicMask(InstructionTable table, int row) {
        if (table.getCellData(row, 0) == null) {
            return;
        }
        AbstractInstructionTable.OperandState mnemonicMaskState = table.getCellData(row, 0).getState();
        this.instructions.get(row).setMasked(mnemonicMaskState.equals((Object)AbstractInstructionTable.OperandState.MASKED));
    }

    private MaskContainer getAllMasks() {
        ArrayList<byte[]> masks = new ArrayList<byte[]>();
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        for (int i = 0; i < this.instructions.size(); ++i) {
            MaskContainer result = this.buildSingleInstructionMask(this.instructions.get(i));
            if (result == null) continue;
            masks.add(result.getMask());
            values.add(result.getValue());
        }
        return this.combineInstructionMasks(masks, values);
    }

    private InstructionMetadata getInstructionMetadata(SleighDebugLogger logger, CodeUnit codeUnit) {
        byte[] mask = logger.getInstructionMask();
        byte[] value = logger.getMaskedBytes(mask);
        return this.createInstructionMetadata(codeUnit, mask, value, true);
    }

    private InstructionMetadata getInstructionMetadata(CodeUnit codeUnit) throws InvalidInputException {
        int cuSize = codeUnit.getLength();
        byte[] mask = new byte[cuSize];
        Arrays.fill(mask, (byte)-1);
        byte[] value = null;
        try {
            value = codeUnit.getBytes();
        }
        catch (MemoryAccessException e) {
            throw new InvalidInputException("Error reading bytes at: " + codeUnit.getAddressString(false, false) + " (possibly unititialized data?)");
        }
        return this.createInstructionMetadata(codeUnit, mask, value, false);
    }

    private InstructionMetadata createInstructionMetadata(CodeUnit codeUnit, byte[] mask, byte[] value, boolean instruction) {
        MaskContainer masks = new MaskContainer(mask, value);
        InstructionMetadata instructionMetadata = new InstructionMetadata(masks);
        instructionMetadata.setAddr(codeUnit.getAddress());
        instructionMetadata.setTextRep(codeUnit.getMnemonicString());
        instructionMetadata.setIsInstruction(instruction);
        return instructionMetadata;
    }

    private void processOperands(SleighDebugLogger logger, CodeUnit codeUnit, InstructionMetadata instructionMetadata) {
        for (int i = 0; i < logger.getNumOperands(); ++i) {
            OperandMetadata operandMetadata = this.getOperandMetadata(logger, codeUnit, i);
            if (operandMetadata == null) continue;
            instructionMetadata.getOperands().add(operandMetadata);
        }
    }

    private OperandMetadata getOperandMetadata(SleighDebugLogger logger, CodeUnit codeUnit, int operand) {
        byte[] mask = logger.getOperandValueMask(operand);
        byte[] value = logger.getMaskedBytes(mask);
        OperandMetadata operandMetadata = new OperandMetadata();
        MaskContainer masks = new MaskContainer(mask, value);
        operandMetadata.setMaskContainer(masks);
        if (codeUnit instanceof Instruction) {
            Instruction instr = (Instruction)codeUnit;
            operandMetadata.setTextRep(instr.getDefaultOperandRepresentation(operand));
            operandMetadata.setOpType(instr.getOperandType(operand));
        }
        return operandMetadata;
    }

    private MaskContainer buildSingleInstructionMask(InstructionMetadata instruction) {
        MaskContainer result;
        if (instruction == null) {
            return null;
        }
        if (instruction.getMaskContainer() == null) {
            return null;
        }
        if (instruction.getMaskContainer().getMask() == null || instruction.getMaskContainer().getValue() == null) {
            return null;
        }
        byte[] tempMask = new byte[instruction.getMaskContainer().getMask().length];
        byte[] tempValue = new byte[instruction.getMaskContainer().getValue().length];
        if (!instruction.isMasked()) {
            tempValue = instruction.getMaskContainer().getValue();
            tempMask = instruction.getMaskContainer().getMask();
        }
        for (OperandMetadata operand : instruction.getOperands()) {
            if (operand.isMasked() || operand.getMaskContainer().getValue() == null || operand.getMaskContainer().getMask() == null || tempValue == null || tempMask == null) continue;
            tempValue = InstructionSearchUtils.byteArrayOr(tempValue, operand.getMaskContainer().getValue());
            tempMask = InstructionSearchUtils.byteArrayOr(tempMask, operand.getMaskContainer().getMask());
        }
        try {
            result = new MaskContainer(tempMask, tempValue);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return result;
    }

    private MaskContainer combineInstructionMasks(List<byte[]> masks, List<byte[]> values) {
        MaskContainer container;
        if (masks.size() != values.size()) {
            throw new IllegalArgumentException();
        }
        int totalLength = 0;
        for (int i = 0; i < values.size(); ++i) {
            totalLength += values.get(i).length;
        }
        byte[] value = new byte[totalLength];
        byte[] mask = new byte[totalLength];
        int index = 0;
        for (int x = 0; x < values.size(); ++x) {
            for (int i = 0; i < values.get(x).length && index < totalLength; ++index, ++i) {
                value[index] = values.get(x)[i];
                mask[index] = masks.get(x)[i];
            }
        }
        try {
            container = new MaskContainer(mask, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return container;
    }

    public InstructionMetadata search(ProgramPlugin plugin, AddressRange searchBounds, TaskMonitor taskMonitor, boolean forwardSearch) {
        if (plugin == null || plugin.getCurrentProgram() == null) {
            throw new IllegalArgumentException("Program provided to search is null");
        }
        if (searchBounds.getMinAddress().compareTo((Object)plugin.getCurrentProgram().getMinAddress()) < 0 || searchBounds.getMaxAddress().compareTo((Object)plugin.getCurrentProgram().getMaxAddress()) > 0) {
            throw new IllegalArgumentException("Search bounds are not valid; must be within the bounds of the program.");
        }
        MaskContainer maskContainer = this.getAllMasks();
        if (InstructionSearchUtils.containsOnBit(maskContainer.getMask())) {
            if (forwardSearch) {
                return this.searchForward(plugin, searchBounds, taskMonitor, maskContainer);
            }
            return this.searchBackward(plugin, searchBounds, taskMonitor, maskContainer);
        }
        return null;
    }

    private InstructionMetadata searchForward(ProgramPlugin plugin, AddressRange searchBounds, TaskMonitor taskMonitor, MaskContainer maskContainer) {
        Address startAddress = searchBounds.getMinAddress();
        Address endAddress = searchBounds.getMaxAddress();
        Address currentPosition = plugin.getProgramLocation().getByteAddress().next();
        taskMonitor.setShowProgressValue(false);
        taskMonitor.setProgress(0L);
        long max = searchBounds.getLength();
        if (currentPosition.compareTo((Object)searchBounds.getMinAddress()) > 0) {
            max = searchBounds.getMaxAddress().subtract(currentPosition);
        }
        taskMonitor.setMaximum(max);
        if (currentPosition.compareTo((Object)startAddress) < 0) {
            currentPosition = startAddress;
        }
        if (currentPosition.compareTo((Object)endAddress) < 0 && (currentPosition = plugin.getCurrentProgram().getMemory().findBytes(currentPosition, endAddress, maskContainer.getValue(), maskContainer.getMask(), true, taskMonitor)) != null) {
            MaskContainer masks = new MaskContainer(maskContainer.getMask(), maskContainer.getValue());
            InstructionMetadata temp = new InstructionMetadata(masks);
            temp.setAddr(currentPosition);
            return temp;
        }
        return null;
    }

    private InstructionMetadata searchBackward(ProgramPlugin plugin, AddressRange searchBounds, TaskMonitor taskMonitor, MaskContainer maskContainer) {
        Address startAddress = searchBounds.getMaxAddress();
        Address endAddress = searchBounds.getMinAddress();
        Address currentPosition = plugin.getProgramLocation().getByteAddress().previous();
        taskMonitor.setShowProgressValue(false);
        taskMonitor.setProgress(0L);
        long max = searchBounds.getLength();
        if (currentPosition.compareTo((Object)searchBounds.getMaxAddress()) < 0) {
            max = currentPosition.subtract(searchBounds.getMinAddress());
        }
        taskMonitor.setMaximum(max);
        if (currentPosition.compareTo((Object)startAddress) > 0) {
            currentPosition = startAddress;
        }
        if (currentPosition.compareTo((Object)endAddress) > 0 && (currentPosition = plugin.getCurrentProgram().getMemory().findBytes(currentPosition, endAddress, maskContainer.getValue(), maskContainer.getMask(), false, taskMonitor)) != null) {
            MaskContainer masks = new MaskContainer(maskContainer.getMask(), maskContainer.getValue());
            InstructionMetadata temp = new InstructionMetadata(masks);
            temp.setAddr(currentPosition);
            return temp;
        }
        return null;
    }

    public List<InstructionMetadata> search(Program program, AddressRange searchBounds, TaskMonitor taskMonitor) throws IllegalArgumentException {
        ArrayList<InstructionMetadata> searchResults = new ArrayList<InstructionMetadata>();
        if (program == null) {
            throw new IllegalArgumentException("Program provided to search is null");
        }
        if (searchBounds.getMinAddress().compareTo((Object)program.getMinAddress()) < 0 || searchBounds.getMaxAddress().compareTo((Object)program.getMaxAddress()) > 0) {
            throw new IllegalArgumentException("Search bounds are not valid; must be within the bounds of the program.");
        }
        MaskContainer maskContainer = this.getAllMasks();
        if (InstructionSearchUtils.containsOnBit(maskContainer.getMask())) {
            Memory mem = program.getMemory();
            Address currentPosition = searchBounds.getMinAddress();
            Address endAddress = searchBounds.getMaxAddress();
            while (currentPosition.compareTo((Object)endAddress) < 0 && (currentPosition = mem.findBytes(currentPosition, endAddress, maskContainer.getValue(), maskContainer.getMask(), true, taskMonitor)) != null) {
                MaskContainer masks = new MaskContainer(maskContainer.getMask(), maskContainer.getValue());
                InstructionMetadata temp = new InstructionMetadata(masks);
                temp.setAddr(currentPosition);
                searchResults.add(temp);
                currentPosition = currentPosition.next();
            }
        }
        return searchResults;
    }

    public static enum UpdateType {
        RELOAD,
        UPDATE;

    }
}

