/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemory;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemoryBlock;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewMemoryRegionBlock;
import ghidra.trace.database.program.DBTraceProgramViewMemorySpaceBlock;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.LockHold;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DBTraceProgramViewMemory
extends AbstractDBTraceProgramViewMemory {
    private final Map<TraceMemoryRegion, DBTraceProgramViewMemoryRegionBlock> regionBlocks = new WeakValueHashMap();
    private final Map<AddressSpace, DBTraceProgramViewMemorySpaceBlock> spaceBlocks = new WeakValueHashMap();

    public DBTraceProgramViewMemory(DBTraceProgramView program) {
        super(program);
    }

    protected TraceMemoryRegion getTopRegion(Function<Long, TraceMemoryRegion> regFunc) {
        return this.program.viewport.getTop(s -> {
            TraceMemoryRegion reg = (TraceMemoryRegion)regFunc.apply((Long)s);
            if (reg != null && this.program.isRegionVisible(reg)) {
                return reg;
            }
            return null;
        });
    }

    protected void forVisibleRegions(Consumer<? super TraceMemoryRegion> action) {
        for (long s : this.program.viewport.getOrderedSnaps()) {
            for (TraceMemoryRegion traceMemoryRegion : this.memoryManager.getRegionsAtSnap(s)) {
                if (!this.program.isRegionVisible(traceMemoryRegion)) continue;
                action.accept(traceMemoryRegion);
            }
        }
    }

    @Override
    void setSnap(long snap) {
        super.setSnap(snap);
        this.updateBytesChanged(null);
    }

    @Override
    protected void recomputeAddressSet() {
        AddressSet temp = new AddressSet();
        try (LockHold hold = this.program.trace.lockRead();){
            this.forVisibleRegions(reg -> temp.add(reg.getRange()));
        }
        this.addressSet = temp;
    }

    protected MemoryBlock getRegionBlock(TraceMemoryRegion region) {
        return this.regionBlocks.computeIfAbsent(region, r -> new DBTraceProgramViewMemoryRegionBlock(this.program, region));
    }

    protected MemoryBlock getSpaceBlock(AddressSpace space) {
        return this.spaceBlocks.computeIfAbsent(space, s -> new DBTraceProgramViewMemorySpaceBlock(this.program, space));
    }

    public MemoryBlock getBlock(Address addr) {
        if (this.forceFullView) {
            return this.getSpaceBlock(addr.getAddressSpace());
        }
        TraceMemoryRegion region = this.getTopRegion(s -> this.memoryManager.getRegionContaining((long)s, addr));
        return region == null ? null : this.getRegionBlock(region);
    }

    public MemoryBlock getBlock(String blockName) {
        if (this.forceFullView) {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace(blockName);
            return space == null ? null : this.getSpaceBlock(space);
        }
        TraceMemoryRegion region = this.getTopRegion(s -> this.memoryManager.getLiveRegionByPath((long)s, blockName));
        return region == null ? null : this.getRegionBlock(region);
    }

    public MemoryBlock[] getBlocks() {
        ArrayList result = new ArrayList();
        if (this.forceFullView) {
            this.forPhysicalSpaces(space -> result.add(this.getSpaceBlock((AddressSpace)space)));
        } else {
            this.forVisibleRegions(reg -> result.add(this.getRegionBlock((TraceMemoryRegion)reg)));
        }
        Collections.sort(result, Comparator.comparing(b -> b.getStart()));
        return result.toArray(new MemoryBlock[result.size()]);
    }

    public void updateAddRegionBlock(TraceMemoryRegion region) {
        this.addRange(region.getRange());
    }

    public void updateChangeRegionBlockName(TraceMemoryRegion region) {
    }

    public void updateChangeRegionBlockFlags(TraceMemoryRegion region) {
    }

    public void updateChangeRegionBlockRange(TraceMemoryRegion region, AddressRange oldRange, AddressRange newRange) {
        this.changeRange(oldRange, newRange);
    }

    public void updateDeleteRegionBlock(TraceMemoryRegion region) {
        this.regionBlocks.remove(region);
        this.removeRange(region.getRange());
    }

    public void updateAddSpaceBlock(AddressSpace space) {
    }

    public void updateDeleteSpaceBlock(AddressSpace space) {
        this.spaceBlocks.remove(space);
    }

    public void updateRefreshBlocks() {
        this.regionBlocks.clear();
        this.spaceBlocks.clear();
        this.recomputeAddressSet();
    }

    public void updateBytesChanged(AddressRange range) {
        if (this.regionBlocks == null) {
            return;
        }
        for (AbstractDBTraceProgramViewMemoryBlock block : this.forceFullView ? this.spaceBlocks.values() : this.regionBlocks.values()) {
            block.invalidateBytesCache(range);
        }
    }
}

